/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.util.Iterator;
import java.util.List;

public final class RegexSupport {
    private static final String PATHLIKE_PATTERN = "([^/]*\\/.*)+";
    private static final String REGEX_ESCAPABLES = "${}[]*.?+()\\/|";

    private RegexSupport() {
    }

    public static String escapedValueOf(Object src) {
        String srcString = String.valueOf(src);
        StringBuffer resultBuffer = new StringBuffer();
        for (int i = 0; i < srcString.length(); ++i) {
            char current = srcString.charAt(i);
            if (REGEX_ESCAPABLES.indexOf(current) > -1) {
                resultBuffer.append('\\');
            }
            resultBuffer.append(current);
        }
        return resultBuffer.toString();
    }

    public static String buildUberPathPattern(List patterns) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            if (RegexSupport.isPathLikePattern(pattern)) {
                pattern = RegexSupport.convertPathLikeToPathRegex(pattern);
            }
            buffer.append('(').append(pattern).append(')');
            if (!it.hasNext()) continue;
            buffer.append(" | ");
        }
        return buffer.toString();
    }

    public static String buildUberClassPattern(List patterns) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            if (RegexSupport.isPathLikePattern(pattern)) {
                pattern = RegexSupport.convertPathLikeToClassRegex(pattern);
            }
            buffer.append('(').append(pattern).append(')');
            if (!it.hasNext()) continue;
            buffer.append(" | ");
        }
        return buffer.toString();
    }

    public static String convertPathLikeToPathRegex(String untrimmedPattern) {
        String pattern = untrimmedPattern.trim();
        StringBuffer buffer = new StringBuffer();
        char curr = '\u0000';
        char next = '\u0000';
        for (int i = 0; i < pattern.length(); ++i) {
            curr = pattern.charAt(i);
            next = i + 1 < pattern.length() ? pattern.charAt(i + 1) : (char)'\u0000';
            if (curr == '*') {
                String repeatPattern = "[^/]";
                if (next == '*') {
                    repeatPattern = ".";
                }
                buffer.append(repeatPattern).append('*');
                continue;
            }
            if (curr == '?') {
                buffer.append(".?");
                continue;
            }
            buffer.append(curr);
        }
        return buffer.toString();
    }

    public static String convertPathLikeToClassRegex(String untrimmedPattern) {
        String pattern = untrimmedPattern.trim();
        StringBuffer buffer = new StringBuffer();
        char curr = '\u0000';
        char next = '\u0000';
        for (int i = 0; i < pattern.length(); ++i) {
            curr = pattern.charAt(i);
            next = i + 1 < pattern.length() ? pattern.charAt(i + 1) : (char)'\u0000';
            if (curr == '*') {
                String repeatPattern = "[^.]";
                if (next == '*') {
                    repeatPattern = ".";
                }
                buffer.append(repeatPattern).append('*');
                continue;
            }
            if (curr == '?') {
                buffer.append(".?");
                continue;
            }
            buffer.append(curr);
        }
        return buffer.toString();
    }

    public static boolean isPathLikePattern(String pattern) {
        return pattern != null && pattern.trim().length() > 0 && pattern.matches(PATHLIKE_PATTERN);
    }
}

