/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.transport.http.client;

import com.ejtone.mars.kernel.util.monitor.AbstractMonitor;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConnMgrMonitor
extends AbstractMonitor {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientConnMgrMonitor.class);
    private final HttpClientConnectionManager connMgr;

    public HttpClientConnMgrMonitor(HttpClientConnectionManager connMgr) {
        this.connMgr = connMgr;
    }

    public HttpClientConnectionManager getConnMgr() {
        return this.connMgr;
    }

    protected Runnable getMonitorTask() {
        return new MgrTask();
    }

    private final class MgrTask
    implements Runnable {
        private MgrTask() {
        }

        @Override
        public void run() {
            try {
                HttpClientConnMgrMonitor.this.connMgr.closeExpiredConnections();
                HttpClientConnMgrMonitor.this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }
}

