/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import me.pushy.sdk.lib.jackson.core.JsonGenerator;
import me.pushy.sdk.lib.jackson.databind.JavaType;
import me.pushy.sdk.lib.jackson.databind.JsonMappingException;
import me.pushy.sdk.lib.jackson.databind.JsonNode;
import me.pushy.sdk.lib.jackson.databind.SerializerProvider;
import me.pushy.sdk.lib.jackson.databind.annotation.JacksonStdImpl;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.pushy.sdk.lib.jackson.databind.jsontype.TypeSerializer;
import me.pushy.sdk.lib.jackson.databind.node.ObjectNode;
import me.pushy.sdk.lib.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, g);
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffixForScalar(value, g);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

