/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import java.io.IOException;
import java.io.OutputStream;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttToken;
import me.pushy.sdk.lib.paho.internal.ClientComms;
import me.pushy.sdk.lib.paho.internal.ClientState;
import me.pushy.sdk.lib.paho.internal.CommsTokenStore;
import me.pushy.sdk.lib.paho.internal.wire.MqttAck;
import me.pushy.sdk.lib.paho.internal.wire.MqttDisconnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttOutputStream;
import me.pushy.sdk.lib.paho.internal.wire.MqttWireMessage;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Thread sendThread = null;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out) {
        this.out = new MqttOutputStream(clientState, out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.sendThread = new Thread((Runnable)this, threadName);
                this.sendThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            log.fine(CLASS_NAME, "stop", "800");
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.sendThread)) {
                    try {
                        while (this.sendThread.isAlive()) {
                            this.clientState.notifyQueueLock();
                            this.sendThread.join(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.sendThread = null;
            log.fine(CLASS_NAME, "stop", "801");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        MqttWireMessage message = null;
        while (this.running && this.out != null) {
            try {
                message = this.clientState.get();
                if (message != null) {
                    log.fine(CLASS_NAME, "run", "802", new Object[]{message.getKey(), message});
                    if (message instanceof MqttAck) {
                        this.out.write(message);
                        this.out.flush();
                        continue;
                    }
                    MqttToken token = this.tokenStore.getToken(message);
                    if (token == null) continue;
                    MqttToken mqttToken = token;
                    synchronized (mqttToken) {
                        block11: {
                            this.out.write(message);
                            try {
                                this.out.flush();
                            }
                            catch (IOException ex) {
                                if (message instanceof MqttDisconnect) break block11;
                                throw ex;
                            }
                        }
                        this.clientState.notifySent(message);
                        continue;
                    }
                }
                log.fine(CLASS_NAME, "run", "803");
                this.running = false;
            }
            catch (MqttException me) {
                this.handleRunException(message, me);
            }
            catch (Exception ex) {
                this.handleRunException(message, ex);
            }
        }
        log.fine(CLASS_NAME, "run", "805");
    }

    private void handleRunException(MqttWireMessage message, Exception ex) {
        String methodName = "handleRunException";
        log.fine(CLASS_NAME, "handleRunException", "804", null, ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.running = false;
        this.clientComms.shutdownConnection(null, mex);
    }
}

