/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import java.util.ArrayList;
import me.pushy.sdk.lib.paho.BufferedMessage;
import me.pushy.sdk.lib.paho.DisconnectedBufferOptions;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttToken;
import me.pushy.sdk.lib.paho.internal.IDisconnectedBufferCallback;
import me.pushy.sdk.lib.paho.internal.wire.MqttWireMessage;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class DisconnectedMessageBuffer
implements Runnable {
    private static final String CLASS_NAME = "DisconnectedMessageBuffer";
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", "DisconnectedMessageBuffer");
    private DisconnectedBufferOptions bufferOpts;
    private ArrayList buffer;
    private Object bufLock = new Object();
    private IDisconnectedBufferCallback callback;

    public DisconnectedMessageBuffer(DisconnectedBufferOptions options) {
        this.bufferOpts = options;
        this.buffer = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(MqttWireMessage message, MqttToken token) throws MqttException {
        BufferedMessage bufferedMessage = new BufferedMessage(message, token);
        Object object = this.bufLock;
        synchronized (object) {
            if (this.buffer.size() < this.bufferOpts.getBufferSize()) {
                this.buffer.add(bufferedMessage);
            } else if (this.bufferOpts.isDeleteOldestMessages()) {
                this.buffer.remove(0);
                this.buffer.add(bufferedMessage);
            } else {
                throw new MqttException(32203);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedMessage getMessage(int messageIndex) {
        Object object = this.bufLock;
        synchronized (object) {
            return (BufferedMessage)this.buffer.get(messageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(int messageIndex) {
        Object object = this.bufLock;
        synchronized (object) {
            this.buffer.remove(messageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.size();
        }
    }

    @Override
    public void run() {
        String methodName = "run";
        log.fine(CLASS_NAME, "run", "516");
        while (this.getMessageCount() > 0) {
            try {
                BufferedMessage bufferedMessage = this.getMessage(0);
                this.callback.publishBufferedMessage(bufferedMessage);
                this.deleteMessage(0);
            }
            catch (MqttException ex) {
                log.warning(CLASS_NAME, "run", "517");
                break;
            }
        }
    }

    public void setPublishCallback(IDisconnectedBufferCallback callback) {
        this.callback = callback;
    }
}

