/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.internal.ClientState;
import me.pushy.sdk.lib.paho.internal.wire.MqttWireMessage;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class MqttOutputStream
extends OutputStream {
    private static final String CLASS_NAME = MqttOutputStream.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private ClientState clientState = null;
    private BufferedOutputStream out;

    public MqttOutputStream(ClientState clientState, OutputStream out) {
        this.clientState = clientState;
        this.out = new BufferedOutputStream(out);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.clientState.notifySentBytes(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.clientState.notifySentBytes(len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(MqttWireMessage message) throws IOException, MqttException {
        String methodName = "write";
        byte[] bytes = message.getHeader();
        byte[] pl = message.getPayload();
        this.out.write(bytes, 0, bytes.length);
        this.clientState.notifySentBytes(bytes.length);
        int chunckSize = 1024;
        for (int offset = 0; offset < pl.length; offset += chunckSize) {
            int length = Math.min(chunckSize, pl.length - offset);
            this.out.write(pl, offset, length);
            this.clientState.notifySentBytes(length);
        }
        log.fine(CLASS_NAME, "write", "500", new Object[]{message});
    }
}

