/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import me.relex.circleindicator.BaseCircleIndicator;

public class CircleIndicator
extends BaseCircleIndicator {
    private ViewPager mViewpager;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            if (CircleIndicator.this.mViewpager.getAdapter() == null || CircleIndicator.this.mViewpager.getAdapter().getCount() <= 0) {
                return;
            }
            CircleIndicator.this.animatePageSelected(position);
        }

        public void onPageScrollStateChanged(int state) {
        }
    };
    private final DataSetObserver mInternalDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            int currentCount;
            super.onChanged();
            if (CircleIndicator.this.mViewpager == null) {
                return;
            }
            PagerAdapter adapter = CircleIndicator.this.mViewpager.getAdapter();
            int newCount = adapter != null ? adapter.getCount() : 0;
            if (newCount == (currentCount = CircleIndicator.this.getChildCount())) {
                return;
            }
            CircleIndicator.this.mLastPosition = CircleIndicator.this.mLastPosition < newCount ? CircleIndicator.this.mViewpager.getCurrentItem() : -1;
            CircleIndicator.this.createIndicators();
        }
    };

    public CircleIndicator(Context context) {
        super(context);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setViewPager(@Nullable ViewPager viewPager) {
        this.mViewpager = viewPager;
        if (this.mViewpager != null && this.mViewpager.getAdapter() != null) {
            this.mLastPosition = -1;
            this.createIndicators();
            this.mViewpager.removeOnPageChangeListener(this.mInternalPageChangeListener);
            this.mViewpager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.mInternalPageChangeListener.onPageSelected(this.mViewpager.getCurrentItem());
        }
    }

    private void createIndicators() {
        PagerAdapter adapter = this.mViewpager.getAdapter();
        int count = adapter == null ? 0 : adapter.getCount();
        this.createIndicators(count, this.mViewpager.getCurrentItem());
    }

    public DataSetObserver getDataSetObserver() {
        return this.mInternalDataSetObserver;
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.mViewpager == null) {
            throw new NullPointerException("can not find Viewpager , setViewPager first");
        }
        this.mViewpager.removeOnPageChangeListener(onPageChangeListener);
        this.mViewpager.addOnPageChangeListener(onPageChangeListener);
    }
}

