/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import me.relex.circleindicator.BaseCircleIndicator;

public class CircleIndicator2
extends BaseCircleIndicator {
    private RecyclerView mRecyclerView;
    private SnapHelper mSnapHelper;
    private final RecyclerView.OnScrollListener mInternalOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            int position = CircleIndicator2.this.getSnapPosition(recyclerView.getLayoutManager());
            if (position == -1) {
                return;
            }
            CircleIndicator2.this.animatePageSelected(position);
        }
    };
    private final RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            int currentCount;
            super.onChanged();
            if (CircleIndicator2.this.mRecyclerView == null) {
                return;
            }
            RecyclerView.Adapter adapter = CircleIndicator2.this.mRecyclerView.getAdapter();
            int newCount = adapter != null ? adapter.getItemCount() : 0;
            if (newCount == (currentCount = CircleIndicator2.this.getChildCount())) {
                return;
            }
            CircleIndicator2.this.mLastPosition = CircleIndicator2.this.mLastPosition < newCount ? CircleIndicator2.this.getSnapPosition(CircleIndicator2.this.mRecyclerView.getLayoutManager()) : -1;
            CircleIndicator2.this.createIndicators();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            this.onChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            super.onItemRangeChanged(positionStart, itemCount, payload);
            this.onChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            super.onItemRangeInserted(positionStart, itemCount);
            this.onChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            this.onChanged();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            super.onItemRangeMoved(fromPosition, toPosition, itemCount);
            this.onChanged();
        }
    };

    public CircleIndicator2(Context context) {
        super(context);
    }

    public CircleIndicator2(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleIndicator2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircleIndicator2(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, @NonNull SnapHelper snapHelper) {
        this.mRecyclerView = recyclerView;
        this.mSnapHelper = snapHelper;
        this.mLastPosition = -1;
        this.createIndicators();
        recyclerView.removeOnScrollListener(this.mInternalOnScrollListener);
        recyclerView.addOnScrollListener(this.mInternalOnScrollListener);
    }

    private void createIndicators() {
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        int count = adapter == null ? 0 : adapter.getItemCount();
        this.createIndicators(count, this.getSnapPosition(this.mRecyclerView.getLayoutManager()));
    }

    public int getSnapPosition(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null) {
            return -1;
        }
        View snapView = this.mSnapHelper.findSnapView(layoutManager);
        if (snapView == null) {
            return -1;
        }
        return layoutManager.getPosition(snapView);
    }

    public RecyclerView.AdapterDataObserver getAdapterDataObserver() {
        return this.mAdapterDataObserver;
    }
}

