/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import me.relex.circleindicator.BaseCircleIndicator;

public class CircleIndicator3
extends BaseCircleIndicator {
    private ViewPager2 mViewpager;
    private final ViewPager2.OnPageChangeCallback mInternalPageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageSelected(int position) {
            if (position == CircleIndicator3.this.mLastPosition || CircleIndicator3.this.mViewpager.getAdapter() == null || CircleIndicator3.this.mViewpager.getAdapter().getItemCount() <= 0) {
                return;
            }
            CircleIndicator3.this.animatePageSelected(position);
        }
    };
    private final RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            int currentCount;
            super.onChanged();
            if (CircleIndicator3.this.mViewpager == null) {
                return;
            }
            RecyclerView.Adapter adapter = CircleIndicator3.this.mViewpager.getAdapter();
            int newCount = adapter != null ? adapter.getItemCount() : 0;
            if (newCount == (currentCount = CircleIndicator3.this.getChildCount())) {
                return;
            }
            CircleIndicator3.this.mLastPosition = CircleIndicator3.this.mLastPosition < newCount ? CircleIndicator3.this.mViewpager.getCurrentItem() : -1;
            CircleIndicator3.this.createIndicators();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            this.onChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            super.onItemRangeChanged(positionStart, itemCount, payload);
            this.onChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            super.onItemRangeInserted(positionStart, itemCount);
            this.onChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            this.onChanged();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            super.onItemRangeMoved(fromPosition, toPosition, itemCount);
            this.onChanged();
        }
    };

    public CircleIndicator3(Context context) {
        super(context);
    }

    public CircleIndicator3(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleIndicator3(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircleIndicator3(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setViewPager(@Nullable ViewPager2 viewPager) {
        this.mViewpager = viewPager;
        if (this.mViewpager != null && this.mViewpager.getAdapter() != null) {
            this.mLastPosition = -1;
            this.createIndicators();
            this.mViewpager.unregisterOnPageChangeCallback(this.mInternalPageChangeCallback);
            this.mViewpager.registerOnPageChangeCallback(this.mInternalPageChangeCallback);
            this.mInternalPageChangeCallback.onPageSelected(this.mViewpager.getCurrentItem());
        }
    }

    private void createIndicators() {
        RecyclerView.Adapter adapter = this.mViewpager.getAdapter();
        int count = adapter == null ? 0 : adapter.getItemCount();
        this.createIndicators(count, this.mViewpager.getCurrentItem());
    }

    public RecyclerView.AdapterDataObserver getAdapterDataObserver() {
        return this.mAdapterDataObserver;
    }
}

