/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import java.util.List;
import me.relex.circleindicator.BaseCircleIndicator;

public class SnackbarBehavior
extends CoordinatorLayout.Behavior<BaseCircleIndicator> {
    public SnackbarBehavior() {
    }

    public SnackbarBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent, @NonNull BaseCircleIndicator child, @NonNull View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, @NonNull BaseCircleIndicator child, @NonNull View dependency) {
        float translationY = this.getTranslationYForSnackbar(parent, child);
        child.setTranslationY(translationY);
        return true;
    }

    private float getTranslationYForSnackbar(CoordinatorLayout parent, BaseCircleIndicator ci) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies((View)ci);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap((View)ci, view)) continue;
            minOffset = Math.min(minOffset, view.getTranslationY() - (float)view.getHeight());
        }
        return minOffset;
    }
}

