/*
 *   Copyright 2013 INFTEL - Proveedor de Servicios de Aplicación
 *   (www.inftel.com.mx). All Rights Reserved (Todos los derechos reservados).
 * 
 *   Copyright 2013 Santos Zatarain Vera (santoszv _at_ inftel.com.mx).
 *   All Rights Reserved (Todos los derechos reservados).
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package mx.com.inftel.shiro.oauth2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.json.JSONObject;

/**
 * Facebook Login authenticating filter.
 *
 * @author Santos Zatarain Vera <santoszv@inftel.com.mx>
 */
public class FacebookLoginAuthenticatingFilter extends AbstractOAuth2AuthenticatingFilter {

    @Override
    protected String getAuthorizeURL(ServletRequest request, ServletResponse response) throws Exception {
        return makeStandardAuthorizeURL(request, response, "https://www.facebook.com/dialog/oauth", "email");
    }

    @Override
    protected JSONObject getOAuth2Principal(ServletRequest request, ServletResponse response) throws Exception {
        StringBuilder sbToken = new StringBuilder(1024);
        sbToken.append("https://graph.facebook.com/oauth/access_token");
        sbToken.append("?");
        sbToken.append(encodeURL("client_id"));
        sbToken.append("=");
        sbToken.append(encodeURL(getClientId()));
        sbToken.append("&");
        sbToken.append(encodeURL("redirect_uri"));
        sbToken.append("=");
        sbToken.append(encodeURL(getRedirectUri()));
        sbToken.append("&");
        sbToken.append(encodeURL("client_secret"));
        sbToken.append("=");
        sbToken.append(encodeURL(getClientSecret()));
        sbToken.append("&");
        sbToken.append(encodeURL("code"));
        sbToken.append("=");
        sbToken.append(encodeURL(request.getParameter("code")));
        sbToken.append("&");
        sbToken.append(encodeURL("grant_type"));
        sbToken.append("=");
        sbToken.append(encodeURL("authorization_code"));

        String[] paramsToken;
        URL urlToken = new URL(sbToken.toString());

        HttpURLConnection connToken = (HttpURLConnection) urlToken.openConnection();
        try {
            connToken.setUseCaches(false);
            connToken.setInstanceFollowRedirects(false);
            connToken.setDoInput(true);
            connToken.setDoOutput(false);
            connToken.setRequestMethod("GET");
            connToken.setRequestProperty("Accept-Charset", "UTF-8");

            byte[] buffer = new byte[1024];
            int read;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            InputStream inputStream = connToken.getInputStream();
            while ((read = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }

            paramsToken = baos.toString("UTF-8").split("&");
        } catch (IOException ex) {
            throw new OAuth2AuthenticationException(ex.getMessage(), ex);
        } finally {
            connToken.disconnect();
        }

        String accessToken = null;
        for (String param : paramsToken) {
            String[] split = param.split("=", 2);
            if ("access_token".equals(split[0])) {
                accessToken = decodeURL(split[1]);
                break;
            }
        }

        StringBuilder sbProfile = new StringBuilder(1024);
        sbProfile.append("https://graph.facebook.com/me");
        sbProfile.append("?");
        sbProfile.append(encodeURL("access_token"));
        sbProfile.append("=");
        sbProfile.append(encodeURL(accessToken));
        sbProfile.append("&");
        sbProfile.append(encodeURL("fields"));
        sbProfile.append("=");
        sbProfile.append(encodeURL("id"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("name"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("first_name"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("middle_name"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("last_name"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("gender"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("locale"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("link"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("username"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("age_range"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("timezone"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("updated_time"));
        sbProfile.append(encodeURL(","));
        sbProfile.append(encodeURL("email"));

        JSONObject joProfile;
        URL urlProfile = new URL(sbProfile.toString());

        HttpURLConnection connProfile = (HttpURLConnection) urlProfile.openConnection();
        try {
            connProfile.setUseCaches(false);
            connProfile.setInstanceFollowRedirects(false);
            connProfile.setDoInput(true);
            connProfile.setDoOutput(false);
            connProfile.setRequestMethod("GET");
            connProfile.setRequestProperty("Accept-Charset", "UTF-8");

            byte[] buffer = new byte[1024];
            int read;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            InputStream inputStream = connProfile.getInputStream();
            while ((read = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }

            joProfile = new JSONObject(baos.toString("UTF-8"));
        } catch (IOException ex) {
            throw new OAuth2AuthenticationException(ex.getMessage(), ex);
        } finally {
            connProfile.disconnect();
        }

        return joProfile;
    }

    @Override
    protected String getOAuth2Credentials(JSONObject principal) throws Exception {
        return principal.getString("email");
    }
}
