/*
 *   Copyright 2013 INFTEL - Proveedor de Servicios de Aplicación
 *   (www.inftel.com.mx). All Rights Reserved (Todos los derechos reservados).
 * 
 *   Copyright 2013 Santos Zatarain Vera (santoszv _at_ inftel.com.mx).
 *   All Rights Reserved (Todos los derechos reservados).
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package mx.com.inftel.shiro.oauth2;

import org.apache.shiro.authc.AuthenticationException;

/**
 * Used when login process has problems. This exception is intended for
 * unexpected errors during determination of principal and/or credentials.
 *
 * @author Santos Zatarain Vera <santoszv@inftel.com.mx>
 */
public class OAuth2AuthenticationException extends AuthenticationException {

    /**
     * Default constructor.
     */
    public OAuth2AuthenticationException() {
    }

    /**
     * Parametrized constructor with the exception's message.
     *
     * @param message Exception's message.
     */
    public OAuth2AuthenticationException(String message) {
        super(message);
    }

    /**
     * Parametrized constructor with the exception's cause.
     *
     * @param cause Exception's cause
     */
    public OAuth2AuthenticationException(Throwable cause) {
        super(cause);
    }

    /**
     * Parametrized constructor with the exception's message and exception's
     * cause.
     *
     * @param message Exception's message.
     * @param cause Exception's cause
     */
    public OAuth2AuthenticationException(String message, Throwable cause) {
        super(message, cause);
    }
}
