/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import androidx.annotation.NonNull;
import java.util.UUID;
import no.nordicsemi.android.dfu.ButtonlessDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.SecureDfuImpl;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

class ExperimentalButtonlessDfuImpl
extends ButtonlessDfuImpl {
    static final UUID DEFAULT_EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID = new UUID(-8196551313441075360L, -6937650605005804976L);
    static final UUID DEFAULT_EXPERIMENTAL_BUTTONLESS_DFU_UUID = new UUID(-8196551313441075360L, -6937650605005804976L);
    static UUID EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID = DEFAULT_EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID;
    static UUID EXPERIMENTAL_BUTTONLESS_DFU_UUID = DEFAULT_EXPERIMENTAL_BUTTONLESS_DFU_UUID;
    private BluetoothGattCharacteristic mButtonlessDfuCharacteristic;

    ExperimentalButtonlessDfuImpl(@NonNull Intent intent, @NonNull DfuBaseService service) {
        super(intent, service);
    }

    @Override
    public boolean isClientCompatible(@NonNull Intent intent, @NonNull BluetoothGatt gatt) {
        BluetoothGattService dfuService = gatt.getService(EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID);
        if (dfuService == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = dfuService.getCharacteristic(EXPERIMENTAL_BUTTONLESS_DFU_UUID);
        if (characteristic == null || characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG) == null) {
            return false;
        }
        this.mButtonlessDfuCharacteristic = characteristic;
        return true;
    }

    @Override
    protected int getResponseType() {
        return 1;
    }

    @Override
    protected BluetoothGattCharacteristic getButtonlessDfuCharacteristic() {
        return this.mButtonlessDfuCharacteristic;
    }

    @Override
    @NonNull
    protected UUID getDfuServiceUUID() {
        return SecureDfuImpl.DFU_SERVICE_UUID;
    }

    @Override
    protected boolean shouldScanForBootloader() {
        return true;
    }

    @Override
    public void performDfu(@NonNull Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.logi("Experimental buttonless service found -> SDK 12.x");
        super.performDfu(intent);
    }
}

