/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal.scanner;

import android.os.Build;
import androidx.annotation.NonNull;
import java.util.Locale;
import java.util.UUID;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScanner;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScannerJB;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScannerLollipop;

public final class BootloaderScannerFactory {
    private static final int ADDRESS_DIFF = 1;

    private BootloaderScannerFactory() {
    }

    public static String getIncrementedAddress(@NonNull String deviceAddress) {
        String firstBytes = deviceAddress.substring(0, 15);
        String lastByte = deviceAddress.substring(15);
        String lastByteIncremented = String.format(Locale.US, "%02X", Integer.valueOf(lastByte, 16) + 1 & 0xFF);
        return firstBytes + lastByteIncremented;
    }

    public static BootloaderScanner getScanner(@NonNull String deviceAddress, @NonNull UUID serviceUuid) {
        String deviceAddressIncremented = BootloaderScannerFactory.getIncrementedAddress(deviceAddress);
        if (Build.VERSION.SDK_INT >= 21) {
            return new BootloaderScannerLollipop(deviceAddress, deviceAddressIncremented, serviceUuid);
        }
        return new BootloaderScannerJB(deviceAddress, deviceAddressIncremented);
    }
}

