/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.app.business.impl;

import com.xdja.cssp.oms.app.bean.QueryBean;
import com.xdja.cssp.oms.app.business.IAppInfoBusiness;
import com.xdja.cssp.oms.app.dao.AppInfoDao;
import com.xdja.cssp.oms.app.entity.AppInfo;
import com.xdja.cssp.oms.app.po.CountStatPo;
import com.xdja.platform.microservice.db.nutz.Paging;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppInfoBusinessImpl
implements IAppInfoBusiness {
    @Autowired
    private AppInfoDao appInfoDao;

    @Override
    public LitePaging<Map<String, Object>> queryAppInfos(QueryBean queryBean, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        Paging<Map<String, Object>> paging = this.appInfoDao.queryAppInfos(queryBean, pageNo, pageSize, sortName, sortType);
        LitePaging litePaging = new LitePaging();
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public LitePaging<Map<String, Object>> queryAppAudits(QueryBean queryBean, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        Paging<Map<String, Object>> paging = this.appInfoDao.queryAppAudits(queryBean, pageNo, pageSize, sortName, sortType);
        LitePaging litePaging = new LitePaging();
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public LitePaging<Map<String, Object>> queryAppManages(QueryBean queryBean, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        Paging<Map<String, Object>> paging = this.appInfoDao.queryAppManages(queryBean, pageNo, pageSize, sortName, sortType);
        LitePaging litePaging = new LitePaging();
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public CountStatPo searchCountStat() {
        Integer appSoldoutCount;
        Integer appRollbackCount;
        Integer appReleaseCount;
        Integer appTurndownCount;
        Integer appAuditCount;
        Integer appBackoutCount;
        CountStatPo po = new CountStatPo();
        Integer packageTotalCount = this.appInfoDao.queryPackageCount().intValue();
        Integer appTotalCount = this.appInfoDao.queryAppCount().intValue();
        Map<Integer, Integer> appCountMap = this.appInfoDao.queryAppStatusCount();
        Integer appDraftCount = appCountMap.get(AppInfo.ENUM_STATUS.draft.value);
        if (appDraftCount == null) {
            appDraftCount = 0;
        }
        if ((appBackoutCount = appCountMap.get(AppInfo.ENUM_STATUS.backout.value)) == null) {
            appBackoutCount = 0;
        }
        if ((appAuditCount = appCountMap.get(AppInfo.ENUM_STATUS.audit.value)) == null) {
            appAuditCount = 0;
        }
        if ((appTurndownCount = appCountMap.get(AppInfo.ENUM_STATUS.turndown.value)) == null) {
            appTurndownCount = 0;
        }
        if ((appReleaseCount = appCountMap.get(AppInfo.ENUM_STATUS.release.value)) == null) {
            appReleaseCount = 0;
        }
        if ((appRollbackCount = appCountMap.get(AppInfo.ENUM_STATUS.rollback.value)) == null) {
            appRollbackCount = 0;
        }
        if ((appSoldoutCount = appCountMap.get(AppInfo.ENUM_STATUS.soldout.value)) == null) {
            appSoldoutCount = 0;
        }
        po.setPackageTotalCount(packageTotalCount.intValue());
        po.setAppTotalCount(appTotalCount.intValue());
        po.setAppDraftCount(appDraftCount.intValue());
        po.setAppBackoutCount(appBackoutCount.intValue());
        po.setAppAuditCount(appAuditCount.intValue());
        po.setAppTurndownCount(appTurndownCount.intValue());
        po.setAppReleaseCount(appReleaseCount.intValue());
        po.setAppRollbackCount(appRollbackCount.intValue());
        po.setAppSoldoutCount(appSoldoutCount.intValue());
        return po;
    }

    @Override
    public List<Map<String, Object>> getAppVersion(Long appId) {
        return this.appInfoDao.getAppVersion(appId);
    }

    @Override
    public Map<String, Object> getCurrAppVersion(Long appId) {
        return this.appInfoDao.getCurrAppVersion(appId);
    }

    @Override
    public Map<String, Object> getAppByPkgInfo(Long appId, Long pkgId) {
        return this.appInfoDao.getAppByPkgInfo(appId, pkgId);
    }
}

