/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.app.dao;

import com.xdja.cssp.oms.app.bean.QueryBean;
import com.xdja.cssp.oms.app.entity.AppInfo;
import com.xdja.cssp.oms.core.util.EscapeUtils;
import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.microservice.db.nutz.Paging;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AppInfoDao {
    private Dao dao = Dao.use((String)"db::omsapp");

    public Paging<Map<String, Object>> queryAppInfos(QueryBean queryBean, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append("a.n_id AS id, ").append("a.c_app_code AS appCode, ").append("a.n_status AS status, ").append("a.c_name AS name, ").append("a.n_type AS type, apr.n_id AS pkgId, ").append("apr.c_version AS version, ").append("apr.n_create_time AS createTime ").append("FROM t_oms_app a LEFT JOIN ").append("t_oms_app_package_release apr ON a.n_current_package_id = apr.n_id  ").append("WHERE 1=1");
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (queryBean != null) {
            if (queryBean.getType() != null) {
                sqlBuilder.append(" AND  a.n_type = @type ");
                param.put("type", queryBean.getType());
            }
            if (queryBean.getStatus() != null) {
                sqlBuilder.append(" AND a.n_status = @status ");
                param.put("status", queryBean.getStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getKeyworld())) {
                sqlBuilder.append(" AND c_name like @keyworld ");
                sqlBuilder.append(" OR c_app_code like @keyworld ");
                param.put("keyworld", "%" + EscapeUtils.escapeSql((String)queryBean.getKeyworld()) + "%");
            }
        }
        sqlBuilder.append(" ORDER BY apr.n_create_time DESC ");
        return this.dao.queryForPaging(sqlBuilder.toString(), param, pageNo.intValue(), pageSize.intValue());
    }

    public Paging<Map<String, Object>> queryAppAudits(QueryBean queryBean, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuffer buf = new StringBuffer("SELECT\ta.n_id AS id,a.c_app_code AS appCode,");
        buf.append(" a.n_status AS status,a.c_name AS name, ");
        buf.append(" a.n_type AS type,ap.c_version AS newVersion,apr.n_id AS apkId,");
        buf.append(" ar.c_content AS content,ar.n_time AS time,apr.c_version AS releaseVersion,apr.n_create_time AS createTime ");
        buf.append(" FROM\tt_oms_app a");
        buf.append(" LEFT JOIN t_oms_app_package ap ON a.n_new_package_id = ap.n_id ");
        buf.append(" LEFT JOIN t_oms_app_record ar ON a.n_id = ar.n_app_id ");
        buf.append(" LEFT JOIN t_oms_app_package_release apr ON a.n_current_package_id = apr.n_id ");
        buf.append(" WHERE  a.n_status > @backout");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("backout", AppInfo.ENUM_STATUS.backout.value);
        if (queryBean != null) {
            if (queryBean.getType() != null) {
                buf.append(" AND  a.n_type = @type ");
                param.put("type", queryBean.getType());
            }
            if (queryBean.getStatus() != null) {
                buf.append(" AND a.n_status = @status ");
                param.put("status", queryBean.getStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getKeyworld())) {
                buf.append(" AND c_name like @keyworld ");
                buf.append(" OR c_app_code like @keyworld ");
                param.put("keyworld", "%" + EscapeUtils.escapeSql((String)queryBean.getKeyworld()) + "%");
            }
        }
        buf.append(" ORDER BY apr.n_create_time DESC ");
        return this.dao.queryForPaging(buf.toString(), param, pageNo.intValue(), pageSize.intValue());
    }

    public Paging<Map<String, Object>> queryAppManages(QueryBean queryBean, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuffer buffer = new StringBuffer("SELECT\toa.n_id AS id,oa.n_status AS status, oa.c_name AS name,oa.c_app_code AS appCode ,oa.n_type AS type,");
        buffer.append(" oa.n_current_package_id AS currId, oa.n_new_package_id AS newId,oap.c_version AS newVersion, oar.c_content AS content,");
        buffer.append(" oar.n_time AS createTime,  apr.c_version AS releaseVersion ,apr.n_create_time as retime");
        buffer.append(" FROM t_oms_app oa LEFT JOIN t_oms_app_package oap ON oa.n_new_package_id= oap.n_id");
        buffer.append(" LEFT JOIN t_oms_app_record oar ON oa.n_id = oar.n_app_id ");
        buffer.append(" LEFT JOIN t_oms_app_package_release apr ON oa.n_current_package_id = apr.n_id ");
        buffer.append("  WHERE 1=1");
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (queryBean != null) {
            if (queryBean.getStatus() != null) {
                buffer.append(" AND oa.n_status=@status ");
                param.put("status", queryBean.getStatus());
            }
            if (queryBean.getType() != null) {
                buffer.append(" AND oa.n_type=@type ");
                param.put("type", queryBean.getType());
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getKeyworld())) {
                buffer.append(" AND (oa.c_name LIKE @name OR oa.c_app_code LIKE @code)");
                param.put("name", "%" + queryBean.getKeyworld() + "%");
                param.put("code", "%" + queryBean.getKeyworld() + "%");
            }
        } else {
            buffer.append(" AND oa.n_status < @status ");
            param.put("status", AppInfo.ENUM_STATUS.soldout.value);
            buffer.append(" ORDER BY apr.n_create_time DESC ");
        }
        return this.dao.queryForPaging(buffer.toString(), param, pageNo.intValue(), pageSize.intValue());
    }

    public Map<Integer, Integer> queryAppStatusCount() {
        HashMap param = new HashMap();
        StringBuilder sqlBuilder = new StringBuilder("SELECT a.n_status as status, COUNT(a.n_status) AS count FROM t_oms_app a group by a.n_status");
        List appCountMapList = this.dao.queryForList(sqlBuilder.toString(), param);
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        for (Map map : appCountMapList) {
            Object status = map.get("status");
            Object count = map.get("count");
            result.put(Integer.valueOf(status.toString()), Integer.valueOf(count.toString()));
        }
        return result;
    }

    public Long queryAppCount() {
        HashMap param = new HashMap();
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(a.n_id) AS count FROM t_oms_app a");
        return this.dao.queryForLong(sqlBuilder.toString(), param);
    }

    public Long queryPackageCount() {
        HashMap param = new HashMap();
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(apr.n_id) AS count FROM t_oms_app_package_release apr");
        return this.dao.queryForLong(sqlBuilder.toString(), param);
    }

    public List<Map<String, Object>> getAppVersion(Long appId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("appId", appId);
        StringBuffer buffer = new StringBuffer("SELECT apr.c_version , n_id , n_app_id FROM t_oms_app_package_release apr WHERE apr.n_app_id = @appId");
        buffer.append(" ORDER BY apr.n_id ASC ");
        return this.dao.queryForList(buffer.toString(), params);
    }

    public Map<String, Object> getCurrAppVersion(Long appId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("appId", appId);
        StringBuffer buffer = new StringBuffer("SELECT oa.c_name,oa.c_logo_url,oa.c_copyright,apr.c_file_size,apr.n_create_time,apr.c_desc, apr.n_id as pkgId, apr.c_version FROM t_oms_app oa");
        buffer.append("  LEFT JOIN t_oms_app_package_release apr ON oa.n_current_package_id = apr.n_id WHERE oa.n_id = @appId");
        return this.dao.queryForMap(buffer.toString(), params);
    }

    public Map<String, Object> getAppByPkgInfo(Long appId, Long pkgId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        StringBuffer buffer = new StringBuffer("SELECT oa.c_name ,oa.c_copyright,oa.c_logo_url,");
        buffer.append(" apr.c_file_size,apr.n_create_time,apr.c_desc, apr.n_id as pkgId, apr.c_version").append("  FROM t_oms_app oa, t_oms_app_package_release apr").append("   WHERE oa.n_id = apr.n_app_id AND oa.n_id=@appId AND apr.n_id =@pkgId");
        params.put("appId", appId);
        params.put("pkgId", pkgId);
        return this.dao.queryForMap(buffer.toString(), params);
    }
}

