/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.app.dao;

import com.xdja.cssp.oms.app.entity.AppInfo;
import com.xdja.cssp.oms.app.entity.AppPackage;
import com.xdja.cssp.oms.app.entity.AppPackageRelease;
import com.xdja.cssp.oms.app.entity.AppPicture;
import com.xdja.cssp.oms.app.entity.AppRecord;
import com.xdja.cssp.oms.app.entity.Label;
import com.xdja.platform.microservice.db.nutz.Dao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AppManagerDao {
    private Dao dao = Dao.use((String)"db::omsapp");

    public Long getAppCode(Long code) {
        String sql = "SELECT MAX(n_id) AS maxId FROM t_oms_app";
        List data = this.dao.queryForList(sql);
        if (((Map)data.get(0)).get("maxId") != null) {
            return Long.parseLong(((Map)data.get(0)).get("maxId").toString()) + code;
        }
        return code;
    }

    public void addApp(final AppInfo info, final String[] lable, final AppPackage ap, final List<AppPicture> listPic, final Long userId) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                int i;
                AppInfo appInfo = (AppInfo)AppManagerDao.this.dao.insert((Object)info);
                Long appId = appInfo.getId();
                AppRecord record = new AppRecord();
                record.setAppId(appId);
                record.setContent("");
                record.setTime(Long.valueOf(System.currentTimeMillis()));
                record.setUserId(userId);
                if (info.getStatus() == AppInfo.ENUM_STATUS.draft.value) {
                    record.setOperater(AppRecord.APP_STATUS.upload.value);
                } else {
                    record.setOperater(AppRecord.APP_STATUS.audit.value);
                }
                AppManagerDao.this.dao.insert((Object)record);
                String lableSql = "INSERT INTO t_oms_app_label(n_label_id,n_app_id)VALUES(@lableId,@appId)";
                int length = lable.length;
                if (null != lable && length > 0) {
                    Sql[] sqls = new Sql[length];
                    for (i = 0; i < length; ++i) {
                        Sql app_sql = Sqls.create((String)lableSql);
                        app_sql.params().set("lableId", (Object)lable[i]).set("appId", (Object)appId);
                        sqls[i] = app_sql;
                    }
                    AppManagerDao.this.dao.execute(sqls);
                }
                ap.setAppId(appId);
                AppPackage pkg = (AppPackage)AppManagerDao.this.dao.insert((Object)ap);
                appInfo.setNewPackageId(pkg.getId());
                AppManagerDao.this.dao.update((Object)appInfo);
                length = listPic.size();
                if (null != listPic && length > 0) {
                    for (i = 0; i < length; ++i) {
                        AppPicture pic = (AppPicture)listPic.get(i);
                        pic.setAppId(appId);
                        pic.setPackageId(pkg.getId());
                        AppManagerDao.this.dao.insert((Object)pic);
                    }
                }
            }
        }});
    }

    public AppInfo getAppInfoById(Long appId) {
        return (AppInfo)this.dao.fetch(AppInfo.class, (Condition)Cnd.where((String)"n_id", (String)"=", (Object)appId));
    }

    public AppPackageRelease getReleaseAppPackage(Long appId) {
        StringBuffer sql = new StringBuffer("SELECT apr.n_id AS id,apr.n_app_id AS appId,");
        sql.append(" apr.c_file_name AS fileName,apr.c_file_size AS fileSize,apr.c_version AS version,");
        sql.append(" apr.c_package_name AS packageName,apr.c_download_url AS downloadUrl,apr.c_file_store_name AS fileStoreName,");
        sql.append(" apr.n_create_time AS createTime,apr.n_real_file_size AS realFileSize,apr.n_status AS status,apr.c_desc AS des");
        sql.append(" FROM t_oms_app_package_release apr LEFT JOIN t_oms_app oa ON apr.n_id = oa.n_current_package_id WHERE n_app_id=@appId");
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        return (AppPackageRelease)this.dao.queryForBean(AppPackageRelease.class, sql.toString(), map);
    }

    public AppPackage getAppPackage(Long appId) {
        StringBuffer sql = new StringBuffer("SELECT apr.n_id AS id,apr.n_app_id AS appId,");
        sql.append(" apr.c_file_name AS fileName,apr.c_file_size AS fileSize,apr.c_version AS version,");
        sql.append(" apr.c_package_name AS packageName,apr.c_download_url AS downloadUrl,apr.c_file_store_name AS fileStoreName,");
        sql.append(" apr.n_create_time AS createTime,apr.n_real_file_size AS realFileSize,apr.n_status AS status,apr.c_desc AS des");
        sql.append(" FROM t_oms_app_package apr LEFT JOIN t_oms_app oa ON apr.n_id = oa.n_new_package_id WHERE apr.n_app_id=@appId");
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        return (AppPackage)this.dao.queryForBean(AppPackage.class, sql.toString(), map);
    }

    public List<Map<String, Object>> getAppLabels(Long appId) {
        String sql = "SELECT ol.c_label_name,ol.n_id FROM t_oms_app_label oal LEFT JOIN t_oms_label ol ON oal.n_label_id = ol.n_id  WHERE oal.n_app_id =@appId ";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        return this.dao.queryForList(sql, map);
    }

    public List<AppPicture> getAppPictures(Long appId, Long appPkgId) {
        String sql = "SELECT n_id as id,n_app_id as appId,n_package_id as packageId,c_file_name as fileName,c_file_size as fileSize,n_create_time as createTime,c_download_url as downloadUrl,c_store_file_name as storeFileName FROM t_oms_app_picture  WHERE n_app_id =@appId and n_package_id=@appPkgId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        map.put("appPkgId", appPkgId);
        return this.dao.queryForList(AppPicture.class, sql, map);
    }

    public void modifyApp(final AppInfo info, final String[] lable, final AppPackage pkg, final List<AppPicture> listPic) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                int i;
                Long appId = info.getId();
                info.setModifyTime(Long.valueOf(System.currentTimeMillis()));
                AppRecord record = (AppRecord)AppManagerDao.this.dao.fetch(AppRecord.class, (Condition)Cnd.where((String)"n_app_id", (String)"=", (Object)appId));
                info.setEditRecordId(record.getId());
                AppManagerDao.this.dao.update((Object)info);
                Sql lableDelsql = Sqls.create((String)"DELETE FROM t_oms_app_label WHERE n_app_id=@appId");
                lableDelsql.params().set("appId", (Object)appId);
                AppManagerDao.this.dao.execute(new Sql[]{lableDelsql});
                String lableSql = "INSERT INTO t_oms_app_label(n_label_id,n_app_id)VALUES(@lableId,@appId)";
                int length = lable.length;
                if (null != lable && length > 0) {
                    Sql[] sqls = new Sql[length];
                    for (i = 0; i < length; ++i) {
                        Sql app_sql = Sqls.create((String)lableSql);
                        app_sql.params().set("lableId", (Object)lable[i]).set("appId", (Object)appId);
                        sqls[i] = app_sql;
                    }
                    AppManagerDao.this.dao.execute(sqls);
                }
                if (info.getStatus() == AppInfo.ENUM_STATUS.draft.value) {
                    record.setOperater(AppRecord.APP_STATUS.modify.value);
                } else {
                    record.setOperater(AppRecord.APP_STATUS.audit.value);
                }
                AppManagerDao.this.dao.update((Object)record);
                pkg.setAppId(appId);
                AppManagerDao.this.dao.update((Object)pkg);
                Sql picDelsql = Sqls.create((String)"DELETE FROM t_oms_app_picture WHERE n_app_id=@appId");
                picDelsql.params().set("appId", (Object)appId);
                AppManagerDao.this.dao.execute(new Sql[]{picDelsql});
                length = listPic.size();
                if (null != listPic && length > 0) {
                    for (i = 0; i < length; ++i) {
                        AppPicture pic = (AppPicture)listPic.get(i);
                        pic.setAppId(appId);
                        pic.setPackageId(pkg.getId());
                        AppManagerDao.this.dao.insert((Object)pic);
                    }
                }
            }
        }});
    }

    public void updateApp(final AppInfo info, final String[] lable, final AppPackage ap, final List<AppPicture> listPic, final Long userId) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                int i;
                AppManagerDao.this.dao.update((Object)info);
                Long appId = info.getId();
                AppRecord record = new AppRecord();
                record.setAppId(appId);
                record.setContent("");
                record.setTime(Long.valueOf(System.currentTimeMillis()));
                record.setUserId(userId);
                if (info.getStatus() == AppInfo.ENUM_STATUS.draft.value) {
                    record.setOperater(AppRecord.APP_STATUS.upload.value);
                } else {
                    record.setOperater(AppRecord.APP_STATUS.audit.value);
                }
                AppManagerDao.this.dao.insert((Object)record);
                String lableSql = "INSERT INTO t_oms_app_label(n_label_id,n_app_id)VALUES(@lableId,@appId)";
                int length = lable.length;
                if (null != lable && length > 0) {
                    Sql[] sqls = new Sql[length];
                    for (i = 0; i < length; ++i) {
                        Sql app_sql = Sqls.create((String)lableSql);
                        app_sql.params().set("lableId", (Object)lable[i]).set("appId", (Object)appId);
                        sqls[i] = app_sql;
                    }
                    AppManagerDao.this.dao.execute(sqls);
                }
                ap.setAppId(appId);
                AppPackage pkg = (AppPackage)AppManagerDao.this.dao.insert((Object)ap);
                info.setNewPackageId(pkg.getId());
                AppManagerDao.this.dao.update((Object)info);
                length = listPic.size();
                if (null != listPic && length > 0) {
                    for (i = 0; i < length; ++i) {
                        AppPicture pic = (AppPicture)listPic.get(i);
                        pic.setAppId(appId);
                        pic.setPackageId(pkg.getId());
                        AppManagerDao.this.dao.insert((Object)pic);
                    }
                }
            }
        }});
    }

    public void updateAppStatus(final Long appId, final Integer appStatus, final Integer recordStatus, final String contents, Long userId) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                AppInfo appInfo = (AppInfo)AppManagerDao.this.dao.fetch(AppInfo.class, (Condition)Cnd.where((String)"n_id", (String)"=", (Object)appId));
                appInfo.setStatus(appStatus);
                AppManagerDao.this.dao.update((Object)appInfo);
                AppRecord record = (AppRecord)AppManagerDao.this.dao.fetch(AppRecord.class, (Condition)Cnd.where((String)"n_app_id", (String)"=", (Object)appId));
                record.setContent(contents);
                record.setOperater(recordStatus);
                record.setTime(Long.valueOf(System.currentTimeMillis()));
                AppManagerDao.this.dao.update((Object)record);
            }
        }});
    }

    public void updateAppPkgToRelease(final Long appId) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                AppPackage appPackage = (AppPackage)AppManagerDao.this.dao.fetch(AppPackage.class, (Condition)Cnd.where((String)"n_app_id", (String)"=", (Object)appId));
                AppPackageRelease release = new AppPackageRelease();
                BeanUtils.copyProperties((Object)appPackage, (Object)release);
                release = (AppPackageRelease)AppManagerDao.this.dao.insert((Object)release);
                AppRecord record = (AppRecord)AppManagerDao.this.dao.fetch(AppRecord.class, (Condition)Cnd.where((String)"n_app_id", (String)"=", (Object)appId));
                AppManagerDao.this.dao.delete((Object)appPackage);
                AppManagerDao.this.dao.delete((Object)record);
                AppInfo appInfo = AppManagerDao.this.getAppInfoById(appId);
                appInfo.setStatus(AppInfo.ENUM_STATUS.release.value);
                appInfo.setCurrentPackageId(release.getId());
                AppManagerDao.this.dao.update((Object)appInfo);
                Sql pic_sql = Sqls.create((String)"UPDATE t_oms_app_picture SET n_package_id=@pkgId WHERE n_package_id=@pkId AND n_app_id=@appId");
                pic_sql.params().set("pkgId", (Object)release.getId()).set("pkId", (Object)appPackage.getId()).set("appId", (Object)appId);
                AppManagerDao.this.dao.execute(new Sql[]{pic_sql});
            }
        }});
    }

    public void insertPkgForRollback(final Long appId, final Long userId, final String contents) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                AppPackageRelease release = (AppPackageRelease)AppManagerDao.this.dao.fetch(AppPackageRelease.class, (Condition)Cnd.where((String)"n_app_id", (String)"=", (Object)appId));
                AppPackage appPackage = new AppPackage();
                BeanUtils.copyProperties((Object)release, (Object)appPackage);
                appPackage = (AppPackage)AppManagerDao.this.dao.insert((Object)appPackage);
                AppRecord record = new AppRecord();
                record.setAppId(appId);
                record.setContent(contents);
                record.setTime(Long.valueOf(System.currentTimeMillis()));
                record.setOperater(AppRecord.APP_STATUS.rollback.value);
                record.setUserId(userId);
                record = (AppRecord)AppManagerDao.this.dao.insert((Object)record);
                AppInfo appInfo = AppManagerDao.this.getAppInfoById(appId);
                if (appInfo.getCurrentPackageId() != null) {
                    String sql_id = "SELECT n_id from t_oms_app_package_release oapr WHERE n_app_id =@appId AND oapr.n_id < @curId ORDER BY oapr.n_id DESC LIMIT 0,1";
                    HashMap<String, Long> params = new HashMap<String, Long>();
                    params.put("appId", appId);
                    params.put("curId", appInfo.getCurrentPackageId());
                    Long currentPackageId = AppManagerDao.this.dao.queryForLong(sql_id, params);
                    appInfo.setCurrentPackageId(currentPackageId);
                }
                appInfo.setNewPackageId(appPackage.getId());
                appInfo.setStatus(AppInfo.ENUM_STATUS.rollback.value);
                appInfo.setEditRecordId(record.getId());
                AppManagerDao.this.dao.update((Object)appInfo);
                AppManagerDao.this.dao.delete((Object)release);
            }
        }});
    }

    public Label addAppLable(Label label) {
        return (Label)this.dao.insert((Object)label);
    }

    public void updateAppLable(Label label) {
        this.dao.update((Object)label);
    }

    public void delAppLable(Long lableId) {
        this.dao.delete(Label.class, lableId.longValue());
    }

    public List<Label> queryAppLable() {
        return this.dao.queryForList(Label.class, "SELECT n_id AS id,c_label_name AS labelName FROM t_oms_label ORDER BY n_id ASC");
    }

    public boolean queryAppLable(String name) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", name);
        return this.dao.queryForList("SELECT n_id AS id,c_label_name AS labelName FROM t_oms_label WHERE c_label_name=@name ORDER BY n_id ASC", data).size() > 0;
    }

    public boolean queryAppLableUsed(Long lableId) {
        HashMap<String, Long> data = new HashMap<String, Long>();
        data.put("lableId", lableId);
        return this.dao.queryForList("SELECT n_id ,n_label_id FROM t_oms_app_label WHERE n_label_id=@lableId ", data).size() > 0;
    }

    public void deleteApp(Long appId, Long appPkgId) {
        Sql sqlPkg;
        String sql = "SELECT count(n_id) FROM t_oms_app_package_release where n_app_id=@appId";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("appId", appId);
        if (this.dao.queryForLong(sql, params) <= 0L) {
            sql = "DELETE FROM t_oms_app_package where n_app_id=@appId";
            sqlPkg = Sqls.create((String)sql);
            sqlPkg.params().set("appId", (Object)appId);
            this.dao.execute(new Sql[]{sqlPkg});
            this.dao.delete(AppInfo.class, appId.longValue());
        }
        sql = "DELETE FROM t_oms_app_package where n_id=@appPkgId";
        sqlPkg = Sqls.create((String)sql);
        sqlPkg.params().set("appPkgId", (Object)appPkgId);
        this.dao.execute(new Sql[]{sqlPkg});
        sql = "DELETE FROM t_oms_app_picture where n_package_id=@appPkgId";
        Sql sqlPic = Sqls.create((String)sql);
        sqlPic.params().set("appPkgId", (Object)appPkgId);
        this.dao.execute(new Sql[]{sqlPic});
    }
}

