/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.customer.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.oms.core.exception.CustomerBindException;
import com.xdja.cssp.oms.customer.bean.ChipBean;
import com.xdja.cssp.oms.customer.bean.CustomerOrder;
import com.xdja.cssp.oms.customer.bean.OrderChip;
import com.xdja.cssp.oms.customer.bean.OrderStatistics;
import com.xdja.cssp.oms.customer.business.ICustomerBusiness;
import com.xdja.cssp.oms.customer.dao.CustomerDao;
import com.xdja.cssp.oms.customer.dao.OrderDao;
import com.xdja.cssp.oms.customer.dao.TpOmsUserCertDao;
import com.xdja.cssp.oms.customer.dao.TpOmsUserDao;
import com.xdja.cssp.oms.customer.entity.Customer;
import com.xdja.cssp.oms.customer.entity.TpOmsUser;
import com.xdja.cssp.oms.customer.entity.TpOmsUserCert;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import com.xdja.platform.microservice.db.nutz.Paging;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerBusinessImpl
implements ICustomerBusiness {
    @Resource
    private TpOmsUserDao omsUserDao;
    @Resource
    private TpOmsUserCertDao userCertDao;
    @Resource
    private CustomerDao customerDao;
    @Resource
    private OrderDao orderDao;

    @Override
    public Pagination<TpOmsUser> queryTpOmsUserList(int pageNo, int pageSize, String condition) {
        List<Customer> customerList = this.customerDao.queryByCustumerName(condition);
        if (customerList.size() == 0) {
            return new Pagination(Integer.valueOf(pageNo), Integer.valueOf(pageSize), 0);
        }
        ArrayList<Long> customerIdList = new ArrayList<Long>();
        for (Customer customer : customerList) {
            customerIdList.add(customer.getId());
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (Customer customer : customerList) {
            map.put(customer.getId(), customer.getName());
        }
        Pagination<TpOmsUser> pagination = this.omsUserDao.queryTpOmsUserList(pageNo, pageSize, customerIdList);
        List list = pagination.getList();
        for (TpOmsUser tpOmsUser : list) {
            tpOmsUser.setCustomerName((String)map.get(tpOmsUser.getCustomerId()));
        }
        return pagination;
    }

    @Override
    public void save(TpOmsUser user) {
        if (this.omsUserDao.isCustomerBind(user.getId(), user.getCustomerId()).booleanValue()) {
            throw new CustomerBindException("\u8be5\u5ba2\u6237\u5df2\u6709\u8d26\u53f7");
        }
        if (user.getId() == null) {
            user.setTime(Long.valueOf(System.currentTimeMillis()));
            user.setStatus(TpOmsUser.ENUM_STATUS.normal.value);
            this.omsUserDao.save(user);
        } else {
            TpOmsUser find = (TpOmsUser)this.omsUserDao.find(user.getId());
            find.setCustomerId(user.getCustomerId());
            find.setUserName(user.getUserName());
            find.setNote(user.getNote());
            this.omsUserDao.save(find);
        }
    }

    @Override
    public TpOmsUser getById(Long id) {
        return (TpOmsUser)this.omsUserDao.find(id);
    }

    @Override
    public void saveChangeStatus(Long id, Boolean isStop) {
        TpOmsUser find = (TpOmsUser)this.omsUserDao.find(id);
        if (isStop.booleanValue()) {
            find.setStatus(TpOmsUser.ENUM_STATUS.stop.value);
        } else {
            find.setStatus(TpOmsUser.ENUM_STATUS.normal.value);
        }
        this.omsUserDao.save(find);
    }

    @Override
    public Pagination<TpOmsUserCert> queryAllUserCert(Long userId, int pageNo, int pageSize) {
        return this.userCertDao.queryAllUserCert(userId, pageNo, pageSize);
    }

    @Override
    public boolean checkCard(String cardId) {
        Search search = new Search(TpOmsUserCert.class);
        search.addFilterEqual("cardId", (Object)cardId);
        return this.userCertDao.count((ISearch)search) > 0;
    }

    @Override
    public void saveBindCard(TpOmsUserCert userCert) {
        this.userCertDao.save(userCert);
    }

    @Override
    public void deleteBind(Long id, Long userId) {
        this.userCertDao.removeById(id);
    }

    @Override
    public LitePaging<Customer> queryCustomerList(int pageNo, int pageSize, String condition) {
        LitePaging litePaging = new LitePaging();
        Paging<Customer> paging = this.customerDao.queryCustomerList(pageNo, pageSize, condition);
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public Customer queryCustomer(Long customerId) {
        return this.customerDao.queryCustomer(customerId);
    }

    @Override
    public List<Customer> queryAllCustomer() {
        return this.customerDao.queryAllCustomer();
    }

    @Override
    public LitePaging<OrderStatistics> queryLinkOrders(int pageNo, int pageSize, Long customerId) {
        LitePaging litePaging = new LitePaging();
        Paging<OrderStatistics> paging = this.orderDao.queryLinkOrders(pageNo, pageSize, customerId);
        List resultList = paging.getList();
        if (resultList.size() != 0) {
            ArrayList<Long> orderIds = new ArrayList<Long>();
            HashMap<Long, Integer> activateMap = new HashMap<Long, Integer>();
            HashMap<Long, Integer> unActivateMap = new HashMap<Long, Integer>();
            for (OrderStatistics order : resultList) {
                orderIds.add(order.getId());
                activateMap.put(order.getId(), 0);
                unActivateMap.put(order.getId(), 0);
            }
            List<Map<String, Object>> orderList = this.orderDao.queryOrderStatus(orderIds);
            for (Map<String, Object> map : orderList) {
                Long orderId = (Long)map.get("orderId");
                Integer status = (Integer)map.get("status");
                if (status.equals(ChipBean.ENUM_CHIP_STATUS.activate.value)) {
                    activateMap.put(orderId, (Integer)activateMap.get(orderId) + 1);
                    continue;
                }
                unActivateMap.put(orderId, (Integer)unActivateMap.get(orderId) + 1);
            }
            for (OrderStatistics order : resultList) {
                order.setActivateCount((Integer)activateMap.get(order.getId()));
                order.setUnActivateCount((Integer)unActivateMap.get(order.getId()));
            }
        }
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public LitePaging<CustomerOrder> queryOrders(int pageNo, int pageSize, String orderName) {
        LitePaging litePaging = new LitePaging();
        Paging<CustomerOrder> paging = this.orderDao.queryOrders(orderName, pageNo, pageSize);
        List resultList = paging.getList();
        if (resultList.size() != 0) {
            ArrayList<Long> orderIds = new ArrayList<Long>();
            HashMap<Long, Integer> activateMap = new HashMap<Long, Integer>();
            HashMap<Long, Integer> unActivateMap = new HashMap<Long, Integer>();
            for (CustomerOrder order : resultList) {
                orderIds.add(order.getOrderId());
                activateMap.put(order.getOrderId(), 0);
                unActivateMap.put(order.getOrderId(), 0);
            }
            List<Map<String, Object>> orderList = this.orderDao.queryOrderStatus(orderIds);
            for (Map<String, Object> map : orderList) {
                Long orderId = (Long)map.get("orderId");
                Integer status = (Integer)map.get("status");
                if (status.equals(ChipBean.ENUM_CHIP_STATUS.activate.value)) {
                    activateMap.put(orderId, (Integer)activateMap.get(orderId) + 1);
                    continue;
                }
                unActivateMap.put(orderId, (Integer)unActivateMap.get(orderId) + 1);
            }
            for (CustomerOrder order : resultList) {
                order.setActivateCount((Integer)activateMap.get(order.getOrderId()));
                order.setUnActivateCount((Integer)unActivateMap.get(order.getOrderId()));
            }
        }
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public LitePaging<OrderChip> queryAssets(int pageNo, int pageSize, Long orderId) {
        LitePaging litePaging = new LitePaging();
        Paging<OrderChip> paging = this.orderDao.queryAssets(orderId, pageNo, pageSize);
        litePaging.setDataList(paging.getList());
        litePaging.setPageNo(Integer.valueOf(paging.getPageNumber()));
        litePaging.setPageSize(Integer.valueOf(paging.getPageSize()));
        litePaging.setTotalCount(Integer.valueOf(paging.getRecordCount()));
        litePaging.setTotalPage(Integer.valueOf(paging.getPageCount()));
        return litePaging;
    }

    @Override
    public CustomerOrder queryOrderDetail(Long orderId) {
        return this.orderDao.queryOrderDetail(orderId);
    }
}

