/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.customer.dao;

import com.xdja.cssp.oms.customer.entity.Customer;
import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.microservice.db.nutz.Paging;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerDao {
    private Dao amsCoreDao = Dao.use((String)"db::amscore");

    public Paging<Customer> queryCustomerList(int pageNo, int pageSize, String condition) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_id id, c_name name, c_tel tel, ").append("c_mail mail, c_link_man linkMan, n_reg_time regTime FROM t_customer ");
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            sqlBuilder.append("WHERE c_name LIKE @name ESCAPE '/' ");
            condition = condition.replaceAll("%", "/%");
            condition = condition.replaceAll("_", "/_");
            param.put("name", "%" + condition + "%");
        }
        sqlBuilder.append("ORDER BY n_reg_time DESC ");
        return this.amsCoreDao.queryForPaging(Customer.class, sqlBuilder.toString(), param, pageNo, pageSize);
    }

    public Customer queryCustomer(Long customerId) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append("cus.c_name name, ").append("cus.c_model model, ").append("dic.c_name modelName, ").append("cus.c_link_man linkMan, ").append("cus.c_mail mail, ").append("cus.c_tel tel, ").append("cus.c_post_code postCode, ").append("cus.c_fax fax, ").append("cus.c_address address, ").append("cus.c_note note ").append("FROM ").append("t_customer cus, t_dic dic ").append("WHERE ").append("cus.n_id = @customerId ").append("AND dic.c_code = cus.c_model ").append("");
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("customerId", customerId);
        return (Customer)this.amsCoreDao.queryForBean(Customer.class, sqlBuilder.toString(), param);
    }

    public List<Customer> queryByCustumerName(String customerName) {
        String sql = "SELECT n_id id, c_name name FROM t_customer WHERE c_name LIKE @customerName ";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("customerName", "%" + customerName + "%");
        return this.amsCoreDao.queryForList(Customer.class, sql, param);
    }

    public List<Customer> queryAllCustomer() {
        String sql = "SELECT n_id id, c_name name FROM t_customer";
        return this.amsCoreDao.queryForList(Customer.class, sql);
    }
}

