/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.customer.dao;

import com.xdja.cssp.oms.customer.bean.CustomerOrder;
import com.xdja.cssp.oms.customer.bean.OrderChip;
import com.xdja.cssp.oms.customer.bean.OrderStatistics;
import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.microservice.db.nutz.Paging;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrderDao {
    private Dao amsCoreDao = Dao.use((String)"db::amscore");

    public Paging<OrderStatistics> queryLinkOrders(int pageNo, int pageSize, Long customerId) {
        String sql = "SELECT n_id id, c_name name, n_time time FROM t_order WHERE n_customer_id = @customerId ORDER BY n_id DESC ";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("customerId", customerId);
        return this.amsCoreDao.queryForPaging(OrderStatistics.class, sql, param, pageNo, pageSize);
    }

    public List<Map<String, Object>> queryOrderStatus(List<Long> orderList) {
        String orderIds = StringUtils.join((Object[])orderList.toArray(), (String)",");
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append("n_order_id orderId, ").append("ai.n_status status ").append("FROM ").append("t_order_asset oa, t_asset_info ai ").append("WHERE ").append("oa.n_asset_id = ai.n_id ").append("AND ").append("oa.n_order_id IN (" + orderIds + ")");
        return this.amsCoreDao.queryForList(sqlBuilder.toString());
    }

    public Paging<CustomerOrder> queryOrders(String orderName, int pageNo, int pageSize) {
        StringBuilder sql = new StringBuilder("SELECT ").append("o.n_id orderId, ").append("c.c_name customerName, ").append("o.n_time time, ").append("o.c_name orderName ").append("FROM ").append("t_order o,t_customer c ").append("WHERE ").append("o.n_customer_id = c.n_id ");
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)orderName)) {
            sql.append("AND o.c_name LIKE @orderName ESCAPE '/' ");
            orderName = orderName.replaceAll("%", "/%");
            orderName = orderName.replaceAll("_", "/_");
            param.put("orderName", "%" + orderName + "%");
        }
        sql.append("ORDER BY o.n_id DESC ");
        return this.amsCoreDao.queryForPaging(CustomerOrder.class, sql.toString(), param, pageNo, pageSize);
    }

    public Paging<OrderChip> queryAssets(Long orderId, int pageNo, int pageSize) {
        StringBuilder sql = new StringBuilder("SELECT ").append("ai.c_asset_identify assetIdentify, ").append("ai.c_asset_type type, ").append("ai.c_relation_asset_identify relationAssetIdentify, ").append("ai.n_status activateStatus, ").append("al.n_time activateTime ").append("FROM ").append("t_order_asset oa INNER JOIN t_asset_info ai ").append("ON oa.n_asset_id = ai.n_id ").append("LEFT JOIN t_activate_log al ").append("ON ai.c_card_no = al.c_card_no ").append("WHERE oa.n_order_id = @orderId ").append("ORDER BY ai.n_id DESC ");
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("orderId", orderId);
        return this.amsCoreDao.queryForPaging(OrderChip.class, sql.toString(), param, pageNo, pageSize);
    }

    public CustomerOrder queryOrderDetail(Long orderId) {
        StringBuilder sql = new StringBuilder("SELECT ").append("o.c_name orderName, ").append("o.n_time time, ").append("c.c_name customerName ").append("FROM ").append("t_order o, t_customer c ").append("WHERE ").append("o.n_customer_id = c.n_id ");
        return (CustomerOrder)this.amsCoreDao.queryForBean(CustomerOrder.class, sql.toString());
    }
}

