/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.customer.service.impl;

import com.xdja.cssp.oms.customer.bean.CustomerOrder;
import com.xdja.cssp.oms.customer.bean.OrderChip;
import com.xdja.cssp.oms.customer.bean.OrderStatistics;
import com.xdja.cssp.oms.customer.business.ICustomerBusiness;
import com.xdja.cssp.oms.customer.entity.Customer;
import com.xdja.cssp.oms.customer.entity.TpOmsUser;
import com.xdja.cssp.oms.customer.entity.TpOmsUserCert;
import com.xdja.cssp.oms.customer.service.ICustomerService;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CustomerServiceImpl
implements ICustomerService {
    @Resource
    private ICustomerBusiness customerBusiness;

    public LitePaging<TpOmsUser> queryTpOmsUserList(int pageNo, int pageSize, String condition) {
        return PagingConverter.convert(this.customerBusiness.queryTpOmsUserList(pageNo, pageSize, condition));
    }

    public void save(TpOmsUser user) {
        this.customerBusiness.save(user);
    }

    public TpOmsUser getById(Long id) {
        return this.customerBusiness.getById(id);
    }

    public void saveChangeStatus(Long id, Boolean isStop) {
        this.customerBusiness.saveChangeStatus(id, isStop);
    }

    public LitePaging<TpOmsUserCert> queryAllUserCert(Long userId, int pageNo, int pageSize) {
        return PagingConverter.convert(this.customerBusiness.queryAllUserCert(userId, pageNo, pageSize));
    }

    public boolean checkCard(String cardId) {
        return this.customerBusiness.checkCard(cardId);
    }

    public void saveBindCard(TpOmsUserCert userCert) {
        this.customerBusiness.saveBindCard(userCert);
    }

    public void deleteBind(Long id, Long userId) {
        this.customerBusiness.deleteBind(id, userId);
    }

    public LitePaging<Customer> queryCustomerList(int pageNo, int pageSize, String condition) {
        return this.customerBusiness.queryCustomerList(pageNo, pageSize, condition);
    }

    public Customer queryCustomer(Long customerId) {
        return this.customerBusiness.queryCustomer(customerId);
    }

    public List<Customer> queryAllCustomer() {
        return this.customerBusiness.queryAllCustomer();
    }

    public LitePaging<OrderStatistics> queryLinkOrders(int pageNo, int pageSize, Long customerId) {
        return this.customerBusiness.queryLinkOrders(pageNo, pageSize, customerId);
    }

    public LitePaging<CustomerOrder> queryOrders(int pageNo, int pageSize, String orderName) {
        return this.customerBusiness.queryOrders(pageNo, pageSize, orderName);
    }

    public LitePaging<OrderChip> queryAssets(int pageNo, int pageSize, Long orderId) {
        return this.customerBusiness.queryAssets(pageNo, pageSize, orderId);
    }

    public CustomerOrder queryOrderDetail(Long orderId) {
        return this.customerBusiness.queryOrderDetail(orderId);
    }
}

