/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.system.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.oms.system.business.IDicBusiness;
import com.xdja.cssp.oms.system.condition.DicCondition;
import com.xdja.cssp.oms.system.dao.TDicJdbcDao;
import com.xdja.cssp.oms.system.dao.TDicJpaDao;
import com.xdja.cssp.oms.system.entity.TDic;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DicBusinessImpl
implements IDicBusiness {
    @Autowired
    private TDicJdbcDao dicJdbcDao;
    @Autowired
    private TDicJpaDao dicJpaDao;

    @Override
    public LitePaging<TDic> queryAllTopDics(DicCondition condition, int page, int length, String orderColName, String orderDir) {
        return PagingConverter.convert(this.dicJdbcDao.queryAllTopDics(condition, page, length, orderColName, orderDir));
    }

    @Override
    public void saveDic(TDic dic) {
        this.dicJpaDao.save(dic);
    }

    @Override
    public TDic getDicById(Long dicId) {
        return (TDic)this.dicJpaDao.find(dicId);
    }

    @Override
    public Boolean deleteDicById(DicCondition condition) {
        this.dicJdbcDao.deleteSubListByCode(condition.getCode());
        this.dicJpaDao.removeById(condition.getDicId());
        return true;
    }

    @Override
    public boolean isDicNameExist(String dicId, String name) {
        Search search = new Search(TDic.class);
        search.addFilterEqual("name", (Object)name);
        if (StringUtils.isNotBlank((CharSequence)dicId)) {
            search.addFilterNotEqual("id", (Object)dicId);
        }
        return this.dicJpaDao.count((ISearch)search) > 0;
    }

    @Override
    public List<TDic> queryAllTopDicsOrderByparentCode() {
        Search search = new Search(TDic.class);
        search.addSortAsc("parentCode");
        search.addSortAsc("sort");
        return this.dicJpaDao.search((ISearch)search);
    }

    @Override
    public boolean isDicCodeExist(String dicId, String name) {
        Search search = new Search(TDic.class);
        search.addFilterEqual("code", (Object)name);
        if (StringUtils.isNotBlank((CharSequence)dicId)) {
            search.addFilterEqual("parentCode", (Object)dicId);
        }
        return this.dicJpaDao.count((ISearch)search) > 0;
    }
}

