/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.system.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.oms.system.business.IUserBusiness;
import com.xdja.cssp.oms.system.dao.TUserCertDao;
import com.xdja.cssp.oms.system.dao.TUserDao;
import com.xdja.cssp.oms.system.dao.TUserRoleDao;
import com.xdja.cssp.oms.system.entity.TUser;
import com.xdja.cssp.oms.system.entity.TUserCert;
import com.xdja.cssp.oms.system.entity.TUserRole;
import com.xdja.platform.datacenter.jpa.business.BaseBusiness;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import com.xdja.platform.security.utils.PasswordUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBusinessImpl
extends BaseBusiness
implements IUserBusiness {
    @Autowired
    private TUserDao userDao;
    @Autowired
    private TUserCertDao userCertDao;
    @Autowired
    private TUserRoleDao userRoleDao;

    @Override
    public TUser queryUserByName(String name) {
        Search search = new Search(TUser.class);
        search.addFilterEqual("userName", (Object)name);
        return (TUser)this.userDao.searchUnique((ISearch)search);
    }

    @Override
    public boolean cardIdIsExist(String uName, String cardId) {
        return this.userDao.queryCardIsBind(uName, cardId) > 0;
    }

    @Override
    public Pagination<TUser> queryAllUsers(TUser condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return this.userDao.queryAllUsers(condition, pageNo, pageSize, sortName, sortType);
    }

    @Override
    public void saveUser(TUser user, Long[] roleId) {
        if (null == user.getId()) {
            user.setType(TUser.ENUM_USER_TYPE.consumerUser.value);
            user.setStatus(TUser.ENUM_USER_STATUS.normalStatus.value);
            user.setDeleteFlag(TUser.ENUM_DELETE_FLAG.normalFlag.value);
            user.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            user.setPassword(PasswordUtils.encodePasswordSHA1((String)"111111"));
        }
        this.userDao.save(user);
        this.userRoleDao.removeUserRoleByUserId(user.getId());
        if (null != roleId) {
            Object[] userRoles = new TUserRole[roleId.length];
            for (int i = 0; i < roleId.length; ++i) {
                TUserRole userRole = new TUserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(roleId[i]);
                userRoles[i] = userRole;
            }
            this.userRoleDao.save(userRoles);
        }
    }

    @Override
    public TUser findById(Long userId) {
        return (TUser)this.userDao.find(userId);
    }

    @Override
    public void deleteUser(Long userId) {
        TUser user = (TUser)this.userDao.find(userId);
        user.setDeleteFlag(TUser.ENUM_DELETE_FLAG.deleteFlag.value);
        user.setUserName("[" + user.getUserName() + "]");
        this.userRoleDao.removeUserRoleByUserId(userId);
        this.userCertDao.removeUserCertByUserId(userId);
    }

    @Override
    public void doResetPwd(Long userId) {
        TUser user = (TUser)this.userDao.find(userId);
        user.setPassword(PasswordUtils.encodePasswordSHA1((String)"111111"));
    }

    @Override
    public void doSuspendUser(Long userId) {
        TUser user = (TUser)this.userDao.find(userId);
        user.setStatus(TUser.ENUM_USER_STATUS.stopStatus.value);
    }

    @Override
    public void doStartUser(Long userId) {
        TUser user = (TUser)this.userDao.find(userId);
        user.setStatus(TUser.ENUM_USER_STATUS.normalStatus.value);
    }

    @Override
    public Integer queryUserCertByCardId(String cardId) {
        return this.userCertDao.queryUserCertByCardId(cardId);
    }

    @Override
    public void saveUserCert(TUserCert userCert) {
        this.userCertDao.save(userCert);
    }

    @Override
    public void deleteUserCertById(Long userCertId) {
        this.userCertDao.removeById(userCertId);
    }

    @Override
    public Pagination<TUserCert> queryAllUserCert(Long userId, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return this.userCertDao.queryAllUserCert(userId, pageNo, pageSize, sortName, sortType);
    }

    @Override
    public boolean isNameExist(String userName, Long userId) {
        Search search = new Search(TUser.class);
        search.addFilterEqual("userName", (Object)userName);
        if (null != userId) {
            search.addFilterNotEqual("id", (Object)userId);
        }
        return this.userDao.count((ISearch)search) > 0;
    }

    @Override
    public void updateUser(TUser user) {
        this.userDao.save(user);
    }
}

