/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.oms.system.service.impl;

import com.xdja.cssp.oms.system.business.IUserBusiness;
import com.xdja.cssp.oms.system.entity.TUser;
import com.xdja.cssp.oms.system.entity.TUserCert;
import com.xdja.cssp.oms.system.service.IUserService;
import com.xdja.cssp.oms.system.util.CertUtil;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.security.cert.X509Certificate;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
implements IUserService {
    @Resource
    private IUserBusiness userBusiness;

    public TUser getUserByUserName(String uName) {
        return this.userBusiness.queryUserByName(uName);
    }

    public boolean cardIdIsExist(String uName, String cardId) {
        return this.userBusiness.cardIdIsExist(uName, cardId);
    }

    public LitePaging<TUser> queryAllUsers(TUser condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return PagingConverter.convert(this.userBusiness.queryAllUsers(condition, pageNo, pageSize, sortName, sortType));
    }

    public void saveUser(TUser user, Long[] roleId) {
        if (null == user) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.userBusiness.saveUser(user, roleId);
    }

    public TUser findById(Long id) {
        if (null != id) {
            return this.userBusiness.findById(id);
        }
        throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
    }

    public void deleteUser(Long id) {
        if (null == id) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.userBusiness.deleteUser(id);
    }

    public void resetPwd(Long id) {
        if (null == id) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.userBusiness.doResetPwd(id);
    }

    public void suspendUser(Long id) {
        if (null == id) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.userBusiness.doSuspendUser(id);
    }

    public void startUser(Long id) {
        if (null == id) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.userBusiness.doStartUser(id);
    }

    public Object[] queryUserCertByCardId(String cert) {
        if (StringUtils.isNotBlank((CharSequence)cert)) {
            Object[] returnArray = new Object[3];
            String[] certArray = cert.split("#");
            String cardId = certArray[0];
            returnArray[0] = cardId;
            X509Certificate clientCert = CertUtil.getCertFromStr16((String)certArray[1]);
            String snToBind = clientCert.getSerialNumber().toString(16).toLowerCase();
            returnArray[1] = snToBind;
            returnArray[2] = 0 < this.userBusiness.queryUserCertByCardId(cardId) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            return returnArray;
        }
        throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
    }

    public void saveUserCert(TUserCert userCert) {
        if (null != userCert) {
            Integer bindCount = this.userBusiness.queryUserCertByCardId(userCert.getCardId());
            if (0 != bindCount) {
                throw new IllegalArgumentException("\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528");
            }
        } else {
            throw new IllegalArgumentException("\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.userBusiness.saveUserCert(userCert);
    }

    public void deleteUserCertById(String userCertId) {
        if (null == userCertId) {
            throw new IllegalArgumentException("\u5361\u7ed1\u5b9aId\u4e3a\u7a7a");
        }
        this.userBusiness.deleteUserCertById(Long.valueOf(userCertId));
    }

    public LitePaging<TUserCert> queryAllUserCert(String userId, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            return PagingConverter.convert(this.userBusiness.queryAllUserCert(Long.valueOf(userId), pageNo, pageSize, sortName, sortType));
        }
        throw new IllegalArgumentException("\u7528\u6237id\u4e3a\u7a7a");
    }

    public boolean isNameExist(String userName, Long userId) {
        return this.userBusiness.isNameExist(userName, userId);
    }

    public void updateUser(TUser user) {
        this.userBusiness.updateUser(user);
    }
}

