/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.runtime.model.impl.IntegrationContextImpl;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.runtime.api.connector.InboundVariablesProvider;

public class IntegrationContextBuilder {
    private InboundVariablesProvider inboundVariablesProvider;

    public IntegrationContextBuilder(InboundVariablesProvider inboundVariablesProvider) {
        this.inboundVariablesProvider = inboundVariablesProvider;
    }

    public IntegrationContext from(IntegrationContextEntity integrationContextEntity, DelegateExecution execution, ActionDefinition actionDefinition) {
        IntegrationContextImpl integrationContext = this.buildFromExecution(execution, actionDefinition);
        integrationContext.setId(integrationContextEntity.getId());
        return integrationContext;
    }

    public IntegrationContext from(DelegateExecution execution, ActionDefinition actionDefinition) {
        return this.buildFromExecution(execution, actionDefinition);
    }

    private IntegrationContextImpl buildFromExecution(DelegateExecution execution, ActionDefinition actionDefinition) {
        ServiceTask serviceTask;
        IntegrationContextImpl integrationContext = new IntegrationContextImpl();
        integrationContext.setProcessInstanceId(execution.getProcessInstanceId());
        integrationContext.setProcessDefinitionId(execution.getProcessDefinitionId());
        integrationContext.setBusinessKey(execution.getProcessInstanceBusinessKey());
        integrationContext.setClientId(execution.getCurrentActivityId());
        if (ExecutionEntity.class.isInstance(execution)) {
            ProcessDefinition processDefinition;
            ExecutionContext executionContext = new ExecutionContext((ExecutionEntity)ExecutionEntity.class.cast(execution));
            ExecutionEntity processInstance = executionContext.getProcessInstance();
            if (processInstance != null) {
                integrationContext.setParentProcessInstanceId(processInstance.getParentProcessInstanceId());
            }
            if ((processDefinition = executionContext.getProcessDefinition()) != null) {
                integrationContext.setProcessDefinitionKey(processDefinition.getKey());
                integrationContext.setProcessDefinitionVersion(Integer.valueOf(processDefinition.getVersion()));
            }
        }
        if ((serviceTask = (ServiceTask)execution.getCurrentFlowElement()) != null) {
            integrationContext.setConnectorType(serviceTask.getImplementation());
            integrationContext.setClientName(serviceTask.getName());
            integrationContext.setClientType(ServiceTask.class.getSimpleName());
        }
        integrationContext.setInBoundVariables(this.inboundVariablesProvider.calculateVariables(execution, actionDefinition));
        return integrationContext;
    }
}

