/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.export.FieldExtensionExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.SendTask;
import org.apache.commons.lang3.StringUtils;

public class SendTaskXMLConverter
extends BaseBpmnXMLConverter {
    public static String getXMLType() {
        return "sendTask";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return SendTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "sendTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        SendTask sendTask = new SendTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)sendTask, xtr);
        sendTask.setType(xtr.getAttributeValue("http://activiti.org/bpmn", "type"));
        if ("##WebService".equals(xtr.getAttributeValue(null, "implementation"))) {
            sendTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE);
            sendTask.setOperationRef(this.parseOperationRef(xtr.getAttributeValue(null, "operationRef"), this.model));
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)sendTask, xtr);
        return sendTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        SendTask sendTask = (SendTask)element;
        if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
            this.writeQualifiedAttribute("type", sendTask.getType(), xtw);
        }
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        SendTask sendTask = (SendTask)element;
        this.didWriteExtensionStartElement = FieldExtensionExport.writeFieldExtensions(sendTask.getFieldExtensions(), this.didWriteExtensionStartElement, xtw);
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    protected String parseOperationRef(String operationRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)operationRef)) {
            int indexOfP = operationRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = operationRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + operationRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + operationRef;
            }
        }
        return result;
    }
}

