/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event.logger;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.event.logger.DatabaseEventFlusher;
import org.activiti.engine.impl.event.logger.EventFlusher;
import org.activiti.engine.impl.event.logger.EventLoggerListener;
import org.activiti.engine.impl.event.logger.handler.ActivityCompensatedEventHandler;
import org.activiti.engine.impl.event.logger.handler.ActivityCompletedEventHandler;
import org.activiti.engine.impl.event.logger.handler.ActivityErrorReceivedEventHandler;
import org.activiti.engine.impl.event.logger.handler.ActivityMessageEventHandler;
import org.activiti.engine.impl.event.logger.handler.ActivitySignaledEventHandler;
import org.activiti.engine.impl.event.logger.handler.ActivityStartedEventHandler;
import org.activiti.engine.impl.event.logger.handler.EventLoggerEventHandler;
import org.activiti.engine.impl.event.logger.handler.ProcessInstanceEndedEventHandler;
import org.activiti.engine.impl.event.logger.handler.ProcessInstanceStartedEventHandler;
import org.activiti.engine.impl.event.logger.handler.SequenceFlowTakenEventHandler;
import org.activiti.engine.impl.event.logger.handler.TaskAssignedEventHandler;
import org.activiti.engine.impl.event.logger.handler.TaskCompletedEventHandler;
import org.activiti.engine.impl.event.logger.handler.TaskCreatedEventHandler;
import org.activiti.engine.impl.event.logger.handler.VariableCreatedEventHandler;
import org.activiti.engine.impl.event.logger.handler.VariableDeletedEventHandler;
import org.activiti.engine.impl.event.logger.handler.VariableUpdatedEventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogger
implements ActivitiEventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventLogger.class);
    private static final String EVENT_FLUSHER_KEY = "eventFlusher";
    protected Clock clock;
    protected ObjectMapper objectMapper;
    protected Map<ActivitiEventType, Class<? extends EventLoggerEventHandler>> eventHandlers = new HashMap<ActivitiEventType, Class<? extends EventLoggerEventHandler>>();
    protected List<EventLoggerListener> listeners;

    public EventLogger(Clock clock) {
        this.clock = clock;
        this.objectMapper = new ObjectMapper();
        this.addEventHandler(ActivitiEventType.TASK_CREATED, TaskCreatedEventHandler.class);
        this.addEventHandler(ActivitiEventType.TASK_COMPLETED, TaskCompletedEventHandler.class);
        this.addEventHandler(ActivitiEventType.TASK_ASSIGNED, TaskAssignedEventHandler.class);
        this.addEventHandler(ActivitiEventType.SEQUENCEFLOW_TAKEN, SequenceFlowTakenEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_COMPLETED, ActivityCompletedEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_STARTED, ActivityStartedEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_SIGNALED, ActivitySignaledEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_MESSAGE_RECEIVED, ActivityMessageEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_COMPENSATE, ActivityCompensatedEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, ActivityErrorReceivedEventHandler.class);
        this.addEventHandler(ActivitiEventType.VARIABLE_CREATED, VariableCreatedEventHandler.class);
        this.addEventHandler(ActivitiEventType.VARIABLE_DELETED, VariableDeletedEventHandler.class);
        this.addEventHandler(ActivitiEventType.VARIABLE_UPDATED, VariableUpdatedEventHandler.class);
    }

    @Override
    public void onEvent(ActivitiEvent event) {
        EventLoggerEventHandler eventHandler = this.getEventHandler(event);
        if (eventHandler != null) {
            CommandContext currentCommandContext = Context.getCommandContext();
            EventFlusher eventFlusher = (EventFlusher)currentCommandContext.getAttribute(EVENT_FLUSHER_KEY);
            if (eventHandler != null && eventFlusher == null) {
                eventFlusher = this.createEventFlusher();
                if (eventFlusher == null) {
                    eventFlusher = new DatabaseEventFlusher();
                }
                currentCommandContext.addAttribute(EVENT_FLUSHER_KEY, eventFlusher);
                currentCommandContext.addCloseListener(eventFlusher);
                currentCommandContext.addCloseListener(new CommandContextCloseListener(){

                    @Override
                    public void closing(CommandContext commandContext) {
                    }

                    @Override
                    public void closed(CommandContext commandContext) {
                        if (EventLogger.this.listeners != null) {
                            for (EventLoggerListener listener : EventLogger.this.listeners) {
                                listener.eventsAdded(EventLogger.this);
                            }
                        }
                    }
                });
            }
            eventFlusher.addEventHandler(eventHandler);
        }
    }

    protected EventLoggerEventHandler getEventHandler(ActivitiEvent event) {
        Class<? extends EventLoggerEventHandler> eventHandlerClass = null;
        if (event.getType().equals((Object)ActivitiEventType.ENTITY_INITIALIZED)) {
            ExecutionEntity executionEntity;
            Object entity = ((ActivitiEntityEvent)event).getEntity();
            if (entity instanceof ExecutionEntity && (executionEntity = (ExecutionEntity)entity).getProcessInstanceId().equals(executionEntity.getId())) {
                eventHandlerClass = ProcessInstanceStartedEventHandler.class;
            }
        } else if (event.getType().equals((Object)ActivitiEventType.ENTITY_DELETED)) {
            ExecutionEntity executionEntity;
            Object entity = ((ActivitiEntityEvent)event).getEntity();
            if (entity instanceof ExecutionEntity && (executionEntity = (ExecutionEntity)entity).getProcessInstanceId().equals(executionEntity.getId())) {
                eventHandlerClass = ProcessInstanceEndedEventHandler.class;
            }
        } else {
            eventHandlerClass = this.eventHandlers.get((Object)event.getType());
        }
        if (eventHandlerClass != null) {
            return this.instantiateEventHandler(event, eventHandlerClass);
        }
        return null;
    }

    protected EventLoggerEventHandler instantiateEventHandler(ActivitiEvent event, Class<? extends EventLoggerEventHandler> eventHandlerClass) {
        try {
            EventLoggerEventHandler eventHandler = eventHandlerClass.newInstance();
            eventHandler.setTimeStamp(this.clock.getCurrentTime());
            eventHandler.setEvent(event);
            eventHandler.setObjectMapper(this.objectMapper);
            return eventHandler;
        }
        catch (Exception e) {
            logger.warn("Could not instantiate " + eventHandlerClass + ", this is most likely a programmatic error");
            return null;
        }
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }

    public void addEventHandler(ActivitiEventType eventType, Class<? extends EventLoggerEventHandler> eventHandlerClass) {
        this.eventHandlers.put(eventType, eventHandlerClass);
    }

    public void addEventLoggerListener(EventLoggerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventLoggerListener>(1);
        }
        this.listeners.add(listener);
    }

    protected EventFlusher createEventFlusher() {
        return null;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<EventLoggerListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<EventLoggerListener> listeners) {
        this.listeners = listeners;
    }
}

