/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.step;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.step.StepDefinitionConverter;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.form.DatePropertyDefinition;
import org.activiti.workflow.simple.definition.form.FormDefinition;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinition;
import org.activiti.workflow.simple.definition.form.ListPropertyDefinition;
import org.activiti.workflow.simple.definition.form.ListPropertyEntry;
import org.activiti.workflow.simple.definition.form.NumberPropertyDefinition;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseStepDefinitionConverter<U extends StepDefinition, T>
implements StepDefinitionConverter<U, T> {
    private static final long serialVersionUID = 1L;

    @Override
    public T convertStepDefinition(StepDefinition stepDefinition, WorkflowDefinitionConversion conversion) {
        StepDefinition typedStepDefinition = stepDefinition;
        T processArtifact = this.createProcessArtifact(typedStepDefinition, conversion);
        this.createAdditionalArtifacts(conversion, typedStepDefinition, processArtifact);
        return processArtifact;
    }

    protected abstract T createProcessArtifact(U var1, WorkflowDefinitionConversion var2);

    protected void createAdditionalArtifacts(WorkflowDefinitionConversion conversion, U stepDefinition, T defaultGeneratedArtifact) {
    }

    protected void addFlowElement(WorkflowDefinitionConversion conversion, FlowElement flowElement) {
        this.addFlowElement(conversion, flowElement, false);
    }

    protected void addFlowElement(WorkflowDefinitionConversion conversion, FlowElement flowElement, boolean addSequenceFlowToLastActivity) {
        if (conversion.isSequenceflowGenerationEnabled() && addSequenceFlowToLastActivity) {
            this.addSequenceFlow(conversion, conversion.getLastActivityId(), flowElement.getId());
        }
        conversion.getProcess().addFlowElement(flowElement);
        if (conversion.isUpdateLastActivityEnabled()) {
            conversion.setLastActivityId(flowElement.getId());
        }
    }

    protected SequenceFlow addSequenceFlow(WorkflowDefinitionConversion conversion, FlowNode sourceActivity, FlowNode targetActivity) {
        return this.addSequenceFlow(conversion, sourceActivity.getId(), targetActivity.getId());
    }

    protected SequenceFlow addSequenceFlow(WorkflowDefinitionConversion conversion, String sourceActivityId, String targetActivityId) {
        return this.addSequenceFlow(conversion, sourceActivityId, targetActivityId, null);
    }

    protected SequenceFlow addSequenceFlow(WorkflowDefinitionConversion conversion, String sourceActivityId, String targetActivityId, String condition) {
        SequenceFlow sequenceFlow = new SequenceFlow();
        sequenceFlow.setId(conversion.getUniqueNumberedId(this.getSequenceFlowPrefix()));
        sequenceFlow.setSourceRef(sourceActivityId);
        sequenceFlow.setTargetRef(targetActivityId);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            sequenceFlow.setConditionExpression(condition);
        }
        conversion.getProcess().addFlowElement((FlowElement)sequenceFlow);
        return sequenceFlow;
    }

    protected String getSequenceFlowPrefix() {
        return "sequenceFlow";
    }

    protected List<FormProperty> convertProperties(FormDefinition formDefinition) {
        ArrayList<FormProperty> formProperties = new ArrayList<FormProperty>();
        for (FormPropertyDefinition propertyDefinition : formDefinition.getFormPropertyDefinitions()) {
            FormProperty formProperty = new FormProperty();
            formProperties.add(formProperty);
            formProperty.setId(propertyDefinition.getName());
            formProperty.setName(propertyDefinition.getName());
            formProperty.setRequired(propertyDefinition.isMandatory());
            String type = null;
            if (propertyDefinition instanceof NumberPropertyDefinition) {
                type = "long";
            } else if (propertyDefinition instanceof DatePropertyDefinition) {
                type = "date";
            } else if (propertyDefinition instanceof ListPropertyDefinition) {
                type = "enum";
                ListPropertyDefinition listDefinition = (ListPropertyDefinition)propertyDefinition;
                if (listDefinition.getEntries().size() > 0) {
                    ArrayList<FormValue> formValues = new ArrayList<FormValue>(listDefinition.getEntries().size());
                    for (ListPropertyEntry entry : listDefinition.getEntries()) {
                        FormValue formValue = new FormValue();
                        formValue.setId(entry.getValue());
                        formValue.setName(entry.getName());
                        formValues.add(formValue);
                    }
                }
            } else {
                type = "string";
            }
            formProperty.setType(type);
        }
        return formProperties;
    }
}

