/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.workflow.simple.definition.AbstractStepDefinitionContainer;
import org.activiti.workflow.simple.definition.ConditionDefinition;
import org.activiti.workflow.simple.definition.ConditionStepListContainer;
import org.activiti.workflow.simple.definition.NamedStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonTypeName(value="list")
public class ListConditionStepDefinition<T>
extends AbstractStepDefinitionContainer<ListConditionStepDefinition<T>>
implements StepDefinition,
NamedStepDefinition {
    private static final long serialVersionUID = 1L;
    protected ConditionStepListContainer<T> stepListContainer;
    protected List<ConditionDefinition> conditions = new ArrayList<ConditionDefinition>();
    protected String name;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected String description;

    public ListConditionStepDefinition() {
    }

    public ListConditionStepDefinition(ConditionStepListContainer<T> stepListContainer) {
        this.stepListContainer = stepListContainer;
    }

    public ListConditionStepDefinition<T> addCondition(String leftOperand, String operator, String rightOperand) {
        ConditionDefinition condition = new ConditionDefinition();
        condition.setLeftOperand(leftOperand);
        condition.setOperator(operator);
        condition.setRightOperand(rightOperand);
        this.conditions.add(condition);
        return this;
    }

    public T endList() {
        if (this.stepListContainer == null) {
            throw new SimpleWorkflowException("Can only call endList when inList was called on a workflow definition first");
        }
        return (T)this.stepListContainer;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ListConditionStepDefinition<T> clone() {
        ListConditionStepDefinition<T> clone = new ListConditionStepDefinition<T>();
        clone.setValues(this);
        return clone;
    }

    @Override
    public void setValues(StepDefinition otherDefinition) {
        if (!(otherDefinition instanceof ListConditionStepDefinition)) {
            throw new SimpleWorkflowException("An instance of SerialStepsDefinition is required to set values");
        }
        ListConditionStepDefinition definition = (ListConditionStepDefinition)otherDefinition;
        this.setId(definition.getId());
        this.setName(definition.getName());
        this.setParameters(new HashMap<String, Object>(otherDefinition.getParameters()));
        this.steps = new ArrayList();
        if (definition.getSteps() != null && definition.getSteps().size() > 0) {
            for (StepDefinition stepDefinition : definition.getSteps()) {
                this.steps.add(stepDefinition.clone());
            }
        }
        this.conditions = new ArrayList<ConditionDefinition>();
        if (definition.getConditions() != null && definition.getConditions().size() > 0) {
            for (ConditionDefinition condition : definition.getConditions()) {
                this.conditions.add(condition.clone());
            }
        }
    }

    public List<ConditionDefinition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionDefinition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

