/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.adblockplus.libadblockplus.HeaderEntry;
import org.adblockplus.libadblockplus.android.Utils;
import timber.log.Timber;

class SharedCookieManager
extends CookieManager {
    static final String PROP_ACCEPT_TPC = "X-Prop-Accept-Tpc";
    static final String PROP_NAVIGATION_URL = "X-Prop-Navigation-Url";
    private static final AtomicReference<CookieHandler> previousCookieManager = new AtomicReference();

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) {
        if (!responseHeaders.containsKey("Location") || !android.webkit.CookieManager.getInstance().acceptCookie()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            if (!"set-cookie".equalsIgnoreCase(entry.getKey())) continue;
            for (String cookie : entry.getValue()) {
                android.webkit.CookieManager.getInstance().setCookie(Utils.getUrlWithoutFragment((String)uri.toString()), cookie);
            }
            android.webkit.CookieManager.getInstance().flush();
            break;
        }
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Arguments can't be null!");
        }
        if (!android.webkit.CookieManager.getInstance().acceptCookie()) {
            return requestHeaders;
        }
        String url = uri.toString();
        String cookie = android.webkit.CookieManager.getInstance().getCookie(Utils.getUrlWithoutFragment((String)url));
        HashMap<String, List<String>> res = new HashMap<String, List<String>>(requestHeaders);
        List acceptThirdPartyCookieHolder = (List)res.remove(PROP_ACCEPT_TPC);
        List navigationUrlHolder = (List)res.remove(PROP_NAVIGATION_URL);
        if (cookie != null) {
            boolean acceptThirdPartyCookie = !Utils.isNullOrEmpty((Collection)acceptThirdPartyCookieHolder) ? Boolean.parseBoolean((String)acceptThirdPartyCookieHolder.get(0)) : false;
            String navigationUrl = !Utils.isNullOrEmpty((Collection)navigationUrlHolder) ? (String)navigationUrlHolder.get(0) : uri.toString();
            List currentCookies = (List)res.get("Cookie");
            if (acceptThirdPartyCookie || Utils.isFirstPartyCookie((String)navigationUrl, (String)uri.toString(), (String)cookie)) {
                if (currentCookies == null) {
                    res.put("Cookie", Arrays.asList(cookie));
                } else {
                    currentCookies.add(cookie);
                }
            }
        }
        return res;
    }

    @Override
    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        throw new UnsupportedOperationException("SharedCookieManager uses settings of android.webkit.CookieManager!");
    }

    @Override
    public CookieStore getCookieStore() {
        throw new UnsupportedOperationException("SharedCookieManager stores cookies in android.webkit.CookieManager storage!");
    }

    private SharedCookieManager() {
    }

    static void injectPropertyHeaders(boolean acceptThirdPartyCookie, String navigationUrl, List<HeaderEntry> requestHeadersList) {
        requestHeadersList.add(new HeaderEntry(PROP_ACCEPT_TPC, String.valueOf(acceptThirdPartyCookie)));
        requestHeadersList.add(new HeaderEntry(PROP_NAVIGATION_URL, navigationUrl));
    }

    static void unloadCookieManager() {
        CookieHandler currentCookieHandler = CookieHandler.getDefault();
        if (currentCookieHandler instanceof SharedCookieManager) {
            CookieHandler.setDefault(previousCookieManager.get());
        }
    }

    static void enforceCookieManager() {
        CookieHandler currentCookieHandler = CookieHandler.getDefault();
        if (!(currentCookieHandler instanceof SharedCookieManager)) {
            previousCookieManager.set(currentCookieHandler);
            CookieHandler.setDefault(new SharedCookieManager());
            if (currentCookieHandler == null) {
                Timber.d((String)"SharedCookieManager set as a default java.net.CookieManager", (Object[])new Object[0]);
            } else {
                Timber.w((String)"SharedCookieManager overwrites existing java.net.CookieManager", (Object[])new Object[0]);
            }
        }
    }
}

