/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android.webview;

import android.webkit.CookieManager;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adblockplus.libadblockplus.AdblockPlusException;
import org.adblockplus.libadblockplus.HttpClient;
import org.adblockplus.libadblockplus.HttpRequest;
import org.adblockplus.libadblockplus.ServerResponse;
import org.adblockplus.libadblockplus.android.Utils;
import org.adblockplus.libadblockplus.android.webview.AdblockWebView;
import org.adblockplus.libadblockplus.android.webview.BaseSiteKeyExtractor;
import org.adblockplus.libadblockplus.android.webview.SharedCookieManager;
import timber.log.Timber;

public class HttpHeaderSiteKeyExtractor
extends BaseSiteKeyExtractor {
    private final AtomicBoolean acceptThirdPartyCookies = new AtomicBoolean(false);

    private static String getReasonPhrase(ServerResponse.NsStatus status) {
        return status.name().replace("_", "");
    }

    public HttpHeaderSiteKeyExtractor(AdblockWebView webView) {
        super(webView);
    }

    @Override
    public WebResourceResponse extract(WebResourceRequest request) {
        ServerResponse response;
        if (!this.isEnabled()) {
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        if (this.getSiteKeysConfiguration() == null || !request.getMethod().equalsIgnoreCase("GET")) {
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        Timber.d((String)"extract() called from Thread %s", (Object[])new Object[]{Thread.currentThread().getId()});
        try {
            response = this.sendRequest(request);
        }
        catch (AdblockPlusException e) {
            Timber.e((Throwable)e, (String)"WebRequest failed", (Object[])new Object[0]);
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        catch (InterruptedException e) {
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        if (!HttpClient.isValidCode((int)response.getResponseStatus()) || HttpClient.isRedirectCode((int)response.getResponseStatus())) {
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        String url = request.getUrl().toString();
        if (response.getFinalUrl() != null) {
            Timber.d((String)"Updating url to %s, was (%s)", (Object[])new Object[]{response.getFinalUrl(), url});
            url = response.getFinalUrl();
        }
        if (response.getInputStream() == null) {
            Timber.w((String)"extract() passes control to WebView", (Object[])new Object[0]);
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        Map requestHeaders = request.getRequestHeaders();
        Map responseHeaders = Utils.convertHeaderEntriesToMap((List)response.getResponseHeaders());
        this.getSiteKeysConfiguration().getSiteKeyVerifier().verifyInHeaders(url, requestHeaders, responseHeaders);
        AdblockWebView adblockWebView = (AdblockWebView)((Object)this.webViewWeakReference.get());
        if (adblockWebView == null) {
            Timber.w((String)"extract() couldn't get a handle to AdblockWebView, returning ALLOW_LOAD", (Object[])new Object[0]);
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
        return new ServerResponseProcessor().process(adblockWebView, url, response, responseHeaders);
    }

    private ServerResponse sendRequest(WebResourceRequest request) throws InterruptedException {
        String requestUrl = request.getUrl().toString();
        Map requestHeadersMap = request.getRequestHeaders();
        final ResponseHolder responseHolder = new ResponseHolder();
        final CountDownLatch latch = new CountDownLatch(1);
        HttpClient.Callback callback = new HttpClient.Callback(){

            public void onFinished(ServerResponse response_) {
                responseHolder.response = response_;
                latch.countDown();
            }
        };
        List requestHeadersList = Utils.convertMapToHeadersList((Map)requestHeadersMap);
        AdblockWebView adblockWebView = (AdblockWebView)((Object)this.webViewWeakReference.get());
        if (adblockWebView != null) {
            SharedCookieManager.injectPropertyHeaders(this.acceptThirdPartyCookies.get(), adblockWebView.getNavigationUrl(), requestHeadersList);
        }
        HttpRequest httpRequest = new HttpRequest(requestUrl, request.getMethod(), requestHeadersList, true, true);
        this.getSiteKeysConfiguration().getHttpClient().request(httpRequest, callback);
        latch.await();
        return responseHolder.response;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            SharedCookieManager.unloadCookieManager();
        }
    }

    @Override
    public void startNewPage() {
        if (this.isEnabled()) {
            AdblockWebView adblockWebView = (AdblockWebView)((Object)this.webViewWeakReference.get());
            if (adblockWebView != null) {
                this.acceptThirdPartyCookies.set(CookieManager.getInstance().acceptThirdPartyCookies((WebView)adblockWebView));
            }
            SharedCookieManager.enforceCookieManager();
        }
    }

    @Override
    public boolean waitForSitekeyCheck(String url, boolean isMainFrame) {
        return false;
    }

    public static class ServerResponseProcessor {
        private static final String NONCE = "nonce-";
        private static final String CSP_SCRIPT_SRC_PARAM = "script-src";
        private static final String CSP_UNSAFE_INLINE = "'unsafe-inline'";
        private static final Pattern NONCE_PATTERN = Pattern.compile(String.format("%s[^;]*'(%s[^']+)'.*;", "script-src", "nonce-"), 2);
        private static final String BODY_CLOSE_TAG = "</body>";

        private boolean containsValidUnsafeInline(String cspHeaderValue) {
            int scriptSrcIndex = cspHeaderValue.indexOf(CSP_SCRIPT_SRC_PARAM);
            if (scriptSrcIndex < 0) {
                return false;
            }
            int unsafeInlineIndex = cspHeaderValue.indexOf(CSP_UNSAFE_INLINE, scriptSrcIndex);
            if (unsafeInlineIndex < 0) {
                return false;
            }
            String inBetween = cspHeaderValue.substring(scriptSrcIndex + CSP_SCRIPT_SRC_PARAM.length(), unsafeInlineIndex);
            return !inBetween.contains("-src ") && !inBetween.contains("-src-elem ") && !inBetween.contains("-src-attr ") && !inBetween.contains("navigate-to ") && !inBetween.contains("form-action ") && !inBetween.contains("base-uri ");
        }

        protected String updateCspHeader(Map<String, String> responseHeaders) {
            String JS_NONCE = null;
            for (Map.Entry<String, String> eachEntry : responseHeaders.entrySet()) {
                if (!eachEntry.getKey().toLowerCase().equals("content-security-policy") || eachEntry.getValue().isEmpty()) continue;
                Timber.d((String)"Found `%s` CSP header", (Object[])new Object[]{eachEntry.getValue()});
                if (!eachEntry.getValue().toLowerCase().contains(CSP_SCRIPT_SRC_PARAM)) break;
                Matcher resultREGEX = NONCE_PATTERN.matcher(eachEntry.getValue());
                if (resultREGEX.find() && resultREGEX.groupCount() == 1) {
                    JS_NONCE = resultREGEX.group(1);
                    Timber.d((String)"Found nonce in CSP header with value `%s`", (Object[])new Object[]{JS_NONCE});
                    break;
                }
                if (this.containsValidUnsafeInline(eachEntry.getValue().toLowerCase())) {
                    Timber.d((String)"Found `%s` in CSP header, no need for update", (Object[])new Object[]{CSP_UNSAFE_INLINE});
                    return null;
                }
                JS_NONCE = NONCE + UUID.randomUUID().toString();
                String[] splittedCSP = eachEntry.getValue().split(CSP_SCRIPT_SRC_PARAM, 2);
                String newCSPvalue = splittedCSP[0].trim() + " " + CSP_SCRIPT_SRC_PARAM + " '" + JS_NONCE + "' " + splittedCSP[1].trim();
                responseHeaders.put(eachEntry.getKey(), newCSPvalue);
                Timber.d((String)"Added nonce to CSP header, new value `%s`", (Object[])new Object[]{newCSPvalue});
                break;
            }
            return JS_NONCE != null ? JS_NONCE.substring(NONCE.length()) : JS_NONCE;
        }

        protected String readFileToString(InputStream inputStream) {
            Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
            return scanner.hasNext() ? scanner.next() : "";
        }

        protected boolean injectJavascript(AdblockWebView webView, String requestUrl, ServerResponse response, Map<String, String> responseHeaders) {
            String htmlString;
            byte[] rawBytes;
            Timber.d((String)"injectJavascript() reads content of `%s`", (Object[])new Object[]{requestUrl});
            if (response.getInputStream() == null) {
                return true;
            }
            try {
                rawBytes = Utils.toByteArray((InputStream)response.getInputStream());
                htmlString = new String(rawBytes);
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"injectJavascript() failed reading input stream to byte array", (Object[])new Object[0]);
                return false;
            }
            if (htmlString.toLowerCase().contains(BODY_CLOSE_TAG) && webView.generateStylesheetForUrl(Utils.getUrlWithoutFragment((String)requestUrl), false)) {
                String JS_NONCE = this.updateCspHeader(responseHeaders);
                String bodyEndWithScriptTag = JS_NONCE == null ? "<script>" + webView.getInjectJs() + "</script></body>" : "<script nonce=\"" + JS_NONCE + "\">" + webView.getInjectJs() + "</script></body>";
                Timber.d((String)"injectJavascript() adds injectJs for `%s`", (Object[])new Object[]{requestUrl});
                int foundIndex = htmlString.lastIndexOf(BODY_CLOSE_TAG);
                if (foundIndex > 0) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(htmlString.substring(0, foundIndex));
                    builder.append(bodyEndWithScriptTag);
                    builder.append(htmlString.substring(foundIndex + BODY_CLOSE_TAG.length()));
                    htmlString = builder.toString();
                }
                try {
                    response.setInputStream((InputStream)new ByteArrayInputStream(htmlString.getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    Timber.e((Throwable)e, (String)"injectJavascript() failed", (Object[])new Object[0]);
                    return false;
                }
            } else {
                Timber.d((String)"injectJavascript() skips injectJs for `%s`", (Object[])new Object[]{requestUrl});
                response.setInputStream((InputStream)new ByteArrayInputStream(rawBytes));
            }
            return true;
        }

        public WebResourceResponse process(AdblockWebView webView, String requestUrl, ServerResponse response, Map<String, String> responseHeaders) {
            String responseContentType = responseHeaders.get("content-type");
            ResourceInfo responseInfo = ResourceInfo.parse(responseContentType);
            if (responseInfo.getMimeType() != null) {
                Timber.d((String)"Removing %s to avoid Content-Type duplication", (Object[])new Object[]{"content-type"});
                responseHeaders.remove("content-type");
                if (responseInfo.getEncoding() != null && responseInfo.isBinary()) {
                    Timber.d((String)"Setting responseEncoding to null for contentType == %s", (Object[])new Object[]{responseInfo.getMimeType()});
                    responseInfo.setEncoding(null);
                }
            } else if (responseHeaders.get("content-length") != null) {
                Integer contentLength = null;
                try {
                    contentLength = Integer.parseInt(responseHeaders.get("content-length").trim());
                }
                catch (NullPointerException | NumberFormatException e) {
                    Timber.e((Throwable)e, (String)"Integer.parseInt(responseHeadersMap.get(HEADER_CONTENT_LENGTH)) failed", (Object[])new Object[0]);
                }
                if (contentLength == null) {
                    Timber.d((String)"Setting responseMimeType to %s", (Object[])new Object[]{"text/plain"});
                    responseInfo.setMimeType("text/plain");
                }
            }
            responseInfo.trim();
            Timber.d((String)"Using responseMimeType and responseEncoding: %s => %s (url == %s)", (Object[])new Object[]{responseInfo.getMimeType() != null ? responseInfo.getMimeType() : "null", responseInfo.getEncoding(), requestUrl});
            if (!webView.getJsInIframesEnabled() || responseInfo.getMimeType() != null && !responseInfo.getMimeType().toLowerCase().contains("text/html") || this.injectJavascript(webView, requestUrl, response, responseHeaders)) {
                return new WebResourceResponse(responseInfo.getMimeType(), responseInfo.getEncoding(), response.getResponseStatus(), HttpHeaderSiteKeyExtractor.getReasonPhrase(response.getStatus()), responseHeaders, response.getInputStream());
            }
            Timber.w((String)"Processing ServerResponse failed, request for `%s` will be repeated!", (Object[])new Object[]{requestUrl});
            return AdblockWebView.WebResponseResult.ALLOW_LOAD;
        }
    }

    private static class ResponseHolder {
        ServerResponse response;

        private ResponseHolder() {
        }
    }

    public static class ResourceInfo {
        private static final String CHARSET = "charset=";
        private static final int CHARSET_LENGTH = "charset=".length();
        private static final String[] BINARY_MIMES = new String[]{"image", "application/octet-stream", "video", "font", "audio"};
        private String mimeType;
        private String encoding;
        private boolean isBinary = false;

        public String getMimeType() {
            return this.mimeType;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public static ResourceInfo parse(String contentType) {
            ResourceInfo resourceInfo = new ResourceInfo();
            if (contentType != null) {
                int semicolonPos = contentType.indexOf(";");
                if (semicolonPos > 0) {
                    resourceInfo.mimeType = contentType.substring(0, semicolonPos);
                    int charsetPos = contentType.indexOf(CHARSET);
                    if (charsetPos >= 0 && charsetPos < contentType.length() - CHARSET_LENGTH) {
                        resourceInfo.encoding = contentType.substring(charsetPos + CHARSET_LENGTH);
                    }
                } else if (contentType.indexOf("/") > 0) {
                    resourceInfo.mimeType = contentType;
                }
                if (resourceInfo.mimeType != null) {
                    for (String binaryMime : BINARY_MIMES) {
                        if (!resourceInfo.mimeType.startsWith(binaryMime)) continue;
                        resourceInfo.isBinary = true;
                        break;
                    }
                }
            }
            return resourceInfo;
        }

        private void trim() {
            if (this.mimeType != null) {
                this.mimeType = this.mimeType.trim();
            }
            if (this.encoding != null) {
                this.encoding = this.encoding.trim();
            }
        }
    }
}

