/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.adblockplus.libadblockplus.AppInfo;
import org.adblockplus.libadblockplus.FileSystem;
import org.adblockplus.libadblockplus.Filter;
import org.adblockplus.libadblockplus.FilterChangeCallback;
import org.adblockplus.libadblockplus.FilterEngine;
import org.adblockplus.libadblockplus.HttpClient;
import org.adblockplus.libadblockplus.IsAllowedConnectionCallback;
import org.adblockplus.libadblockplus.JsValue;
import org.adblockplus.libadblockplus.LogSystem;
import org.adblockplus.libadblockplus.Platform;
import org.adblockplus.libadblockplus.android.AndroidHttpClient;
import org.adblockplus.libadblockplus.android.AndroidHttpClientEngineStateWrapper;
import org.adblockplus.libadblockplus.android.AndroidHttpClientResourceWrapper;
import org.adblockplus.libadblockplus.android.IsAllowedConnectionCallbackImpl;
import org.adblockplus.libadblockplus.android.Subscription;
import org.adblockplus.libadblockplus.android.TimberLogSystem;
import org.adblockplus.libadblockplus.android.Utils;
import timber.log.Timber;

public final class AdblockEngine {
    public static final String BASE_PATH_DIRECTORY = "adblock";
    private static final String FORCE_SYNC_WHEN_ENABLED_PREF = "_force_sync_when_enabled";
    private static final String ENGINE_STORAGE_NAME = "abp-engine.pref";
    private volatile Platform platform;
    private volatile FilterEngine filterEngine;
    private volatile LogSystem logSystem;
    private volatile FileSystem fileSystem;
    private volatile HttpClient httpClient;
    private volatile FilterChangeCallback filterChangeCallback;
    private volatile boolean elemhideEnabled = true;
    private volatile boolean enabled = true;
    private final Set<SettingsChangedListener> settingsChangedListeners = new HashSet<SettingsChangedListener>();
    private SharedPreferences prefs;

    public synchronized AdblockEngine addSettingsChangedListener(SettingsChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("SettingsChangedListener cannot be null");
        }
        this.settingsChangedListeners.add(listener);
        return this;
    }

    public synchronized AdblockEngine removeSettingsChangedListener(SettingsChangedListener listener) {
        this.settingsChangedListeners.remove(listener);
        return this;
    }

    public static AppInfo generateAppInfo(Context context, String application, String applicationVersion) {
        String sdkVersion = String.valueOf(Build.VERSION.SDK_INT);
        String locale = Locale.getDefault().toString().replace('_', '-');
        if (locale.startsWith("iw-")) {
            locale = "he" + locale.substring(2);
        }
        AppInfo.Builder builder = AppInfo.builder().setApplicationVersion(sdkVersion).setLocale(locale);
        if (application != null) {
            builder.setApplication(application);
        }
        if (applicationVersion != null) {
            builder.setApplicationVersion(applicationVersion);
        }
        return builder.build();
    }

    public static AppInfo generateAppInfo(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String application = context.getPackageName();
            String applicationVersion = packageInfo.versionName;
            return AdblockEngine.generateAppInfo(context, application, applicationVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void onLowMemory() {
        if (this.platform != null && this.platform.getJsEngine() != null) {
            this.platform.getJsEngine().onLowMemory();
        }
    }

    public Subscription[] getRecommendedSubscriptions() {
        List<org.adblockplus.libadblockplus.Subscription> subscriptions = this.filterEngine.fetchAvailableSubscriptions();
        return AdblockEngine.convertJsSubscriptions(subscriptions);
    }

    public static Builder builder(Context context, AppInfo appInfo, String basePath) {
        return new Builder(context, appInfo, basePath);
    }

    public static Builder builder(Context context, String basePath) {
        AppInfo appInfo = AdblockEngine.generateAppInfo(context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        IsAllowedConnectionCallbackImpl isAllowedConnectionCallback = new IsAllowedConnectionCallbackImpl(connectivityManager);
        return AdblockEngine.builder(context, appInfo, basePath).setIsAllowedConnectionCallback(isAllowedConnectionCallback);
    }

    public void dispose() {
        Timber.w((String)"Dispose", (Object[])new Object[0]);
        if (this.filterEngine != null) {
            if (this.filterChangeCallback != null) {
                this.filterEngine.removeFilterChangeCallback();
            }
            this.platform.dispose();
            this.platform = null;
        }
        if (this.filterChangeCallback != null) {
            this.filterChangeCallback.dispose();
            this.filterChangeCallback = null;
        }
    }

    public boolean isElemhideEnabled() {
        return this.elemhideEnabled;
    }

    private static Subscription convertJsSubscription(org.adblockplus.libadblockplus.Subscription jsSubscription) {
        Subscription subscription = new Subscription(jsSubscription.getTitle(), jsSubscription.getUrl(), jsSubscription.getLanguages(), jsSubscription.getHomepage(), jsSubscription.getAuthor());
        return subscription;
    }

    private static Subscription[] convertJsSubscriptions(List<org.adblockplus.libadblockplus.Subscription> jsSubscriptions) {
        Subscription[] subscriptions = new Subscription[jsSubscriptions.size()];
        for (int i = 0; i < subscriptions.length; ++i) {
            subscriptions[i] = AdblockEngine.convertJsSubscription(jsSubscriptions.get(i));
        }
        return subscriptions;
    }

    public Subscription[] getListedSubscriptions() {
        List<org.adblockplus.libadblockplus.Subscription> subscriptions = this.filterEngine.getListedSubscriptions();
        return AdblockEngine.convertJsSubscriptions(subscriptions);
    }

    public String getDocumentationLink() {
        JsValue jsPref = this.filterEngine.getPref("documentation_link");
        try {
            String string = jsPref.toString();
            return string;
        }
        finally {
            jsPref.dispose();
        }
    }

    public void clearSubscriptions() {
        for (org.adblockplus.libadblockplus.Subscription s : this.filterEngine.getListedSubscriptions()) {
            s.removeFromList();
        }
    }

    public void setSubscription(String url) {
        this.clearSubscriptions();
        org.adblockplus.libadblockplus.Subscription sub = this.filterEngine.getSubscription(url);
        if (sub != null) {
            sub.addToList();
        }
    }

    public void setSubscriptions(Collection<String> urls) {
        List<org.adblockplus.libadblockplus.Subscription> currentSubscriptions = this.filterEngine.getListedSubscriptions();
        for (org.adblockplus.libadblockplus.Subscription eachCurrentSubscription : currentSubscriptions) {
            if (urls.contains(eachCurrentSubscription.getUrl())) continue;
            eachCurrentSubscription.removeFromList();
        }
        for (String eachNewUrl : urls) {
            org.adblockplus.libadblockplus.Subscription eachNewSubscription = this.filterEngine.getSubscription(eachNewUrl);
            if (eachNewSubscription == null || eachNewSubscription.isListed()) continue;
            eachNewSubscription.addToList();
        }
    }

    public void configureDisabledByDefault(Context context) {
        this.setEnabled(false);
        this.ensurePrefs(context);
        if (!this.prefs.contains(FORCE_SYNC_WHEN_ENABLED_PREF)) {
            this.saveShouldForceSyncWhenEnabled(true);
        }
    }

    private void ensurePrefs(Context context) {
        if (this.prefs == null) {
            this.loadPrefs(context);
        }
    }

    private void saveShouldForceSyncWhenEnabled(boolean force) {
        this.prefs.edit().putBoolean(FORCE_SYNC_WHEN_ENABLED_PREF, force).commit();
    }

    private void loadPrefs(Context context) {
        this.prefs = context.getSharedPreferences(ENGINE_STORAGE_NAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        boolean valueChanged = this.enabled != enabled;
        this.enabled = enabled;
        if (enabled && valueChanged && this.prefs != null && this.shouldForceSyncWhenEnabled()) {
            this.forceSync();
        }
        if (valueChanged) {
            AdblockEngine adblockEngine = this;
            synchronized (adblockEngine) {
                for (SettingsChangedListener listener : this.settingsChangedListeners) {
                    listener.onEnableStateChanged(enabled);
                }
            }
        }
    }

    private void forceSync() {
        Timber.i((String)"Force updating subscription filters", (Object[])new Object[0]);
        List<org.adblockplus.libadblockplus.Subscription> listed = this.filterEngine.getListedSubscriptions();
        for (org.adblockplus.libadblockplus.Subscription subscription : listed) {
            subscription.updateFilters();
        }
        this.saveShouldForceSyncWhenEnabled(false);
    }

    private boolean shouldForceSyncWhenEnabled() {
        return this.prefs.getBoolean(FORCE_SYNC_WHEN_ENABLED_PREF, false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAcceptableAdsSubscriptionURL() {
        return this.filterEngine.getAcceptableAdsSubscriptionURL();
    }

    public boolean isAcceptableAdsEnabled() {
        return this.filterEngine.isAcceptableAdsEnabled();
    }

    public void setAcceptableAdsEnabled(boolean enabled) {
        this.filterEngine.setAcceptableAdsEnabled(enabled);
    }

    public MatchesResult matches(String url, Set<FilterEngine.ContentType> contentTypes, String parent, String siteKey, boolean specificOnly) {
        if (!this.enabled) {
            return MatchesResult.NOT_ENABLED;
        }
        Filter filter = this.filterEngine.matches(url, contentTypes, parent, siteKey, specificOnly);
        if (filter == null) {
            return MatchesResult.NOT_FOUND;
        }
        Timber.d((String)"Found filter `%s` for url `%s`", (Object[])new Object[]{filter.getRaw(), url});
        return filter.getType() == Filter.Type.BLOCKING ? MatchesResult.BLOCKED : MatchesResult.NOT_FOUND;
    }

    public void addDomainWhitelistingFilter(String domain) {
        Filter filter = Utils.createDomainAllowlistingFilter(this.filterEngine, domain);
        this.filterEngine.addFilter(filter);
    }

    public boolean isContentAllowlisted(String url, Set<FilterEngine.ContentType> contentTypes, List<String> referrerChain, String siteKey) {
        return this.filterEngine.isContentAllowlisted(url, contentTypes, referrerChain, siteKey);
    }

    public String getElementHidingStyleSheet(String url, String domain, List<String> referrerChain, String sitekey, boolean specificOnly) {
        if (!this.enabled || !this.elemhideEnabled || this.isContentAllowlisted(url, FilterEngine.ContentType.maskOf(FilterEngine.ContentType.DOCUMENT), referrerChain, sitekey) || this.isContentAllowlisted(url, FilterEngine.ContentType.maskOf(FilterEngine.ContentType.ELEMHIDE), referrerChain, sitekey)) {
            return "";
        }
        return this.filterEngine.getElementHidingStyleSheet(domain, specificOnly);
    }

    public List<FilterEngine.EmulationSelector> getElementHidingEmulationSelectors(String url, String domain, List<String> referrerChain, String sitekey) {
        if (!this.enabled || !this.elemhideEnabled || this.isContentAllowlisted(url, FilterEngine.ContentType.maskOf(FilterEngine.ContentType.DOCUMENT), referrerChain, sitekey) || this.isContentAllowlisted(url, FilterEngine.ContentType.maskOf(FilterEngine.ContentType.ELEMHIDE), referrerChain, sitekey)) {
            return new ArrayList<FilterEngine.EmulationSelector>();
        }
        return this.filterEngine.getElementHidingEmulationSelectors(domain);
    }

    public FilterEngine getFilterEngine() {
        return this.filterEngine;
    }

    public void initAllowlistedDomains(List<String> domains) {
        if (domains != null) {
            for (String domain : domains) {
                this.addDomainAllowlistingFilter(domain);
            }
        }
    }

    public void addDomainAllowlistingFilter(String domain) {
        Filter filter = Utils.createDomainAllowlistingFilter(this.filterEngine, domain);
        this.filterEngine.addFilter(filter);
    }

    public void removeDomainAllowlistingFilter(String domain) {
        Filter filter = Utils.createDomainAllowlistingFilter(this.filterEngine, domain);
        this.filterEngine.removeFilter(filter);
    }

    public static class Builder
    implements Factory {
        private Context context;
        private Map<String, Integer> urlToResourceIdMap;
        private boolean forceUpdatePreloadedSubscriptions = true;
        private AndroidHttpClientResourceWrapper.Storage resourceStorage;
        private HttpClient androidHttpClient;
        private final AppInfo appInfo;
        private final String basePath;
        private IsAllowedConnectionCallback isAllowedConnectionCallback;
        private Long v8IsolateProviderPtr;
        private final AdblockEngine engine = new AdblockEngine();

        protected Builder(Context context, AppInfo appInfo, String basePath) {
            this.engine.elemhideEnabled = true;
            this.context = context;
            this.appInfo = appInfo;
            this.basePath = basePath;
        }

        public Builder setDisableByDefault() {
            this.engine.configureDisabledByDefault(this.context);
            return this;
        }

        public Builder enableElementHiding(boolean enable) {
            this.engine.elemhideEnabled = enable;
            return this;
        }

        public Builder setHttpClient(HttpClient httpClient) {
            this.androidHttpClient = httpClient;
            return this;
        }

        public Builder preloadSubscriptions(Context context, Map<String, Integer> urlToResourceIdMap, AndroidHttpClientResourceWrapper.Storage storage) {
            this.context = context;
            this.urlToResourceIdMap = urlToResourceIdMap;
            this.resourceStorage = storage;
            return this;
        }

        public Builder setForceUpdatePreloadedSubscriptions(boolean forceUpdate) {
            this.forceUpdatePreloadedSubscriptions = forceUpdate;
            return this;
        }

        public Builder setIsAllowedConnectionCallback(IsAllowedConnectionCallback callback) {
            this.isAllowedConnectionCallback = callback;
            return this;
        }

        public Builder useV8IsolateProvider(long v8IsolateProviderPtr) {
            this.v8IsolateProviderPtr = v8IsolateProviderPtr;
            return this;
        }

        public Builder setFilterChangeCallback(FilterChangeCallback callback) {
            this.engine.filterChangeCallback = callback;
            return this;
        }

        private void initRequests() {
            if (this.androidHttpClient == null) {
                this.androidHttpClient = new AndroidHttpClient(true);
            }
            this.engine.httpClient = this.androidHttpClient;
            if (this.urlToResourceIdMap != null) {
                AndroidHttpClientResourceWrapper wrapper = new AndroidHttpClientResourceWrapper(this.context, this.engine.httpClient, this.urlToResourceIdMap, this.resourceStorage);
                if (this.forceUpdatePreloadedSubscriptions) {
                    wrapper.setListener(new AndroidHttpClientResourceWrapper.Listener(){

                        @Override
                        public void onIntercepted(String url, int resourceId) {
                            Timber.d((String)"Force subscription update for intercepted URL %s", (Object[])new Object[]{url});
                            if (Builder.this.engine.filterEngine != null) {
                                Builder.this.engine.filterEngine.updateFiltersAsync(url);
                            }
                        }
                    });
                }
                this.engine.httpClient = wrapper;
            }
            this.engine.httpClient = new AndroidHttpClientEngineStateWrapper(this.engine.httpClient, this.engine);
        }

        private void initCallbacks() {
            if (this.engine.filterChangeCallback != null) {
                this.engine.filterEngine.setFilterChangeCallback(this.engine.filterChangeCallback);
            }
        }

        @Override
        public AdblockEngine build() {
            this.initRequests();
            this.createEngines();
            if (this.engine.isEnabled()) {
                this.engine.ensurePrefs(this.context);
                if (this.engine.shouldForceSyncWhenEnabled()) {
                    this.engine.saveShouldForceSyncWhenEnabled(false);
                    this.engine.forceSync();
                }
            }
            this.initCallbacks();
            return this.engine;
        }

        private void createEngines() {
            this.engine.logSystem = new TimberLogSystem();
            this.engine.fileSystem = null;
            this.engine.platform = new Platform(this.engine.logSystem, this.engine.fileSystem, this.engine.httpClient, this.basePath);
            if (this.v8IsolateProviderPtr != null) {
                this.engine.platform.setUpJsEngine(this.appInfo, this.v8IsolateProviderPtr);
            } else {
                this.engine.platform.setUpJsEngine(this.appInfo);
            }
            this.engine.platform.setUpFilterEngine(this.isAllowedConnectionCallback);
            this.engine.filterEngine = this.engine.platform.getFilterEngine();
        }
    }

    public static interface Factory {
        public AdblockEngine build();
    }

    public static enum MatchesResult {
        BLOCKED,
        ALLOWLISTED,
        NOT_FOUND,
        NOT_ENABLED;

    }

    public static interface SettingsChangedListener {
        public void onEnableStateChanged(boolean var1);
    }
}

