/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import java.lang.ref.WeakReference;
import org.adblockplus.libadblockplus.AdblockPlusException;
import org.adblockplus.libadblockplus.HttpClient;
import org.adblockplus.libadblockplus.HttpRequest;
import org.adblockplus.libadblockplus.ServerResponse;
import org.adblockplus.libadblockplus.android.AdblockEngine;
import timber.log.Timber;

public class AndroidHttpClientEngineStateWrapper
extends HttpClient {
    private final HttpClient httpClient;
    private final WeakReference<AdblockEngine> engineRef;

    public AndroidHttpClientEngineStateWrapper(HttpClient httpClient, AdblockEngine engine) {
        this.httpClient = httpClient;
        this.engineRef = new WeakReference<AdblockEngine>(engine);
    }

    @Override
    public void request(HttpRequest request, HttpClient.Callback callback) {
        AdblockEngine engine = (AdblockEngine)this.engineRef.get();
        ServerResponse response = new ServerResponse();
        if (engine != null && !engine.isEnabled()) {
            Timber.d((String)"Connection refused: engine is disabled", (Object[])new Object[0]);
            response.setResponseStatus(0);
            response.setStatus(ServerResponse.NsStatus.ERROR_CONNECTION_REFUSED);
            callback.onFinished(response);
            return;
        }
        try {
            this.httpClient.request(request, callback);
        }
        catch (AdblockPlusException e) {
            Timber.e((Throwable)e, (String)"WebRequest failed", (Object[])new Object[0]);
            response.setResponseStatus(500);
            response.setStatus(ServerResponse.NsStatus.ERROR_FAILURE);
            callback.onFinished(response);
        }
    }
}

