/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import android.net.ConnectivityManager;

public enum ConnectionType {
    WIFI("wifi"){

        @Override
        public boolean isRequiredConnection(ConnectivityManager manager) {
            return manager.getActiveNetworkInfo().getType() == 1;
        }
    }
    ,
    WIFI_NON_METERED("wifi_non_metered"){

        @Override
        public boolean isRequiredConnection(ConnectivityManager manager) {
            return manager.getActiveNetworkInfo().getType() == 1 && !manager.isActiveNetworkMetered();
        }
    }
    ,
    ANY("any"){

        @Override
        public boolean isRequiredConnection(ConnectivityManager manager) {
            return true;
        }
    };

    private String value;

    public String getValue() {
        return this.value;
    }

    public abstract boolean isRequiredConnection(ConnectivityManager var1);

    private ConnectionType(String value) {
        this.value = value;
    }

    public static ConnectionType findByValue(String value) {
        if (value == null) {
            return null;
        }
        for (ConnectionType eachConnectionType : ConnectionType.values()) {
            if (!eachConnectionType.getValue().equals(value)) continue;
            return eachConnectionType;
        }
        return null;
    }
}

