/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

public class AppInfo {
    public final String version;
    public final String name;
    public final String application;
    public final String applicationVersion;
    public final String locale;

    private AppInfo(String version, String name, String application, String applicationVersion, String locale) {
        this.version = version;
        this.name = name;
        this.application = application;
        this.applicationVersion = applicationVersion;
        this.locale = locale;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String version = "1.0";
        private String name = "libadblockplus-android";
        private String application = "android";
        private String applicationVersion = "0";
        private String locale = "en_US";

        private Builder() {
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public Builder setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public AppInfo build() {
            return new AppInfo(this.version, this.name, this.application, this.applicationVersion, this.locale);
        }
    }
}

