/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.nio.ByteBuffer;
import org.adblockplus.libadblockplus.Disposable;
import org.adblockplus.libadblockplus.Disposer;

public abstract class FileSystem {
    public abstract void read(String var1, ReadCallback var2, Callback var3);

    public abstract void write(String var1, ByteBuffer var2, Callback var3);

    public abstract void move(String var1, String var2, Callback var3);

    public abstract void remove(String var1, Callback var2);

    public abstract void stat(String var1, StatCallback var2);

    private static native void callbackOnFinished(long var0, String var2);

    private static native void callbackDtor(long var0);

    private static native void readCallbackOnFinished(long var0, ByteBuffer var2);

    private static native void readCallbackDtor(long var0);

    private static native void statCallbackOnFinished(long var0, StatResult var2, String var3);

    private static native void statCallbackDtor(long var0);

    private static native void registerNatives();

    static {
        System.loadLibrary("adblockplus-jni");
        FileSystem.registerNatives();
    }

    public static class StatResult {
        private boolean exists;
        private long modified;

        public StatResult(boolean exists, long modified) {
            this.exists = exists;
            this.modified = modified;
        }

        public boolean isExists() {
            return this.exists;
        }

        public long getModified() {
            return this.modified;
        }
    }

    public static class StatCallback
    implements Disposable {
        protected final long ptr;
        private final Disposer disposer;

        StatCallback(long ptr) {
            this.ptr = ptr;
            this.disposer = new Disposer(this, new DisposeWrapper(this.ptr));
        }

        @Override
        public void dispose() {
            this.disposer.dispose();
        }

        public void onFinished(StatResult result, String error) {
            FileSystem.statCallbackOnFinished(this.ptr, result, error);
        }

        private static final class DisposeWrapper
        implements Disposable {
            private final long ptr;

            public DisposeWrapper(long ptr) {
                this.ptr = ptr;
            }

            @Override
            public void dispose() {
                FileSystem.statCallbackDtor(this.ptr);
            }
        }
    }

    public static class ReadCallback
    implements Disposable {
        protected final long ptr;
        private final Disposer disposer;

        ReadCallback(long ptr) {
            this.ptr = ptr;
            this.disposer = new Disposer(this, new DisposeWrapper(this.ptr));
        }

        @Override
        public void dispose() {
            this.disposer.dispose();
        }

        public void onFinished(ByteBuffer output) {
            FileSystem.readCallbackOnFinished(this.ptr, output);
        }

        private static final class DisposeWrapper
        implements Disposable {
            private final long ptr;

            public DisposeWrapper(long ptr) {
                this.ptr = ptr;
            }

            @Override
            public void dispose() {
                FileSystem.readCallbackDtor(this.ptr);
            }
        }
    }

    public static class Callback
    implements Disposable {
        protected final long ptr;
        private final Disposer disposer;

        Callback(long ptr) {
            this.ptr = ptr;
            this.disposer = new Disposer(this, new DisposeWrapper(this.ptr));
        }

        @Override
        public void dispose() {
            this.disposer.dispose();
        }

        public void onFinished(String error) {
            FileSystem.callbackOnFinished(this.ptr, error);
        }

        private static final class DisposeWrapper
        implements Disposable {
            private final long ptr;

            public DisposeWrapper(long ptr) {
                this.ptr = ptr;
            }

            @Override
            public void dispose() {
                FileSystem.callbackDtor(this.ptr);
            }
        }
    }
}

