/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus;

import java.lang.ref.WeakReference;
import org.adblockplus.libadblockplus.FilterEngine;

public final class Filter {
    private final Type type;
    private final String raw;
    private WeakReference<FilterEngine> filterEngine;

    private Filter(Type type, String raw) {
        this.type = type;
        this.raw = raw;
    }

    public Type getType() {
        return this.type;
    }

    public String getRaw() {
        return this.raw;
    }

    @Deprecated
    public boolean isListed() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        return engine != null && engine.getListedFilters().contains(this);
    }

    @Deprecated
    public void addToList() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine != null) {
            engine.addFilter(this);
        }
    }

    @Deprecated
    public void removeFromList() {
        FilterEngine engine = (FilterEngine)this.filterEngine.get();
        if (engine != null) {
            engine.removeFilter(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return this.type == filter.type && this.raw.equals(filter.raw);
    }

    void setFilterEngine(FilterEngine filterEngine) {
        this.filterEngine = new WeakReference<FilterEngine>(filterEngine);
    }

    public static enum Type {
        BLOCKING,
        EXCEPTION,
        ELEMHIDE,
        ELEMHIDE_EXCEPTION,
        ELEMHIDE_EMULATION,
        COMMENT,
        INVALID;

    }
}

