/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import android.content.Context;
import android.content.SharedPreferences;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.adblockplus.libadblockplus.HttpClient;
import org.adblockplus.libadblockplus.HttpRequest;
import org.adblockplus.libadblockplus.ServerResponse;
import org.adblockplus.libadblockplus.android.Utils;
import timber.log.Timber;

public class AndroidHttpClientResourceWrapper
extends HttpClient {
    public static final String EASYLIST = "https://easylist-downloads.adblockplus.org/easylist.txt";
    public static final String EASYLIST_INDONESIAN = "https://easylist-downloads.adblockplus.org/abpindo+easylist.txt";
    public static final String EASYLIST_BULGARIAN = "https://easylist-downloads.adblockplus.org/bulgarian_list+easylist.txt";
    public static final String EASYLIST_CHINESE = "https://easylist-downloads.adblockplus.org/easylistchina+easylist.txt";
    public static final String EASYLIST_CZECH_SLOVAK = "https://easylist-downloads.adblockplus.org/easylistczechslovak+easylist.txt";
    public static final String EASYLIST_DUTCH = "https://easylist-downloads.adblockplus.org/easylistdutch+easylist.txt";
    public static final String EASYLIST_GERMAN = "https://easylist-downloads.adblockplus.org/easylistgermany+easylist.txt";
    public static final String EASYLIST_ISRAELI = "https://easylist-downloads.adblockplus.org/israellist+easylist.txt";
    public static final String EASYLIST_ITALIAN = "https://easylist-downloads.adblockplus.org/easylistitaly+easylist.txt";
    public static final String EASYLIST_LITHUANIAN = "https://easylist-downloads.adblockplus.org/easylistlithuania+easylist.txt";
    public static final String EASYLIST_LATVIAN = "https://easylist-downloads.adblockplus.org/latvianlist+easylist.txt";
    public static final String EASYLIST_ARABIAN_FRENCH = "https://easylist-downloads.adblockplus.org/liste_ar+liste_fr+easylist.txt";
    public static final String EASYLIST_FRENCH = "https://easylist-downloads.adblockplus.org/liste_fr+easylist.txt";
    public static final String EASYLIST_POLISH = "https://easylist-downloads.adblockplus.org/easylistpolish+easylist.txt";
    public static final String EASYLIST_ROMANIAN = "https://easylist-downloads.adblockplus.org/rolist+easylist.txt";
    public static final String EASYLIST_RUSSIAN = "https://easylist-downloads.adblockplus.org/ruadlist+easylist.txt";
    public static final String ACCEPTABLE_ADS = "https://easylist-downloads.adblockplus.org/exceptionrules.txt";
    private Context context;
    private HttpClient httpClient;
    private Map<String, Integer> urlToResourceIdMap;
    private Storage storage;
    private Listener listener;

    public AndroidHttpClientResourceWrapper(Context context, HttpClient httpClient, Map<String, Integer> urlToResourceIdMap, Storage storage) {
        this.context = context;
        this.httpClient = httpClient;
        this.urlToResourceIdMap = Collections.synchronizedMap(urlToResourceIdMap);
        this.storage = storage;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void request(HttpRequest request, HttpClient.Callback callback) {
        String urlWithoutParams = Utils.getUrlWithoutParams(request.getUrl());
        Integer resourceId = this.urlToResourceIdMap.get(urlWithoutParams);
        if (resourceId != null) {
            if (!this.storage.contains(urlWithoutParams)) {
                Timber.w((String)"Intercepting request for %s with resource #%d", (Object[])new Object[]{request.getUrl(), resourceId});
                ServerResponse response = this.buildResourceContentResponse(resourceId);
                this.storage.put(urlWithoutParams);
                callback.onFinished(response);
                if (this.listener != null) {
                    this.listener.onIntercepted(request.getUrl(), resourceId);
                }
                return;
            }
            Timber.d((String)"Already intercepted request for %s", (Object[])new Object[]{urlWithoutParams});
        } else {
            Timber.d((String)"Skip intercepting request for %s", (Object[])new Object[]{urlWithoutParams});
        }
        this.httpClient.request(request, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer readResourceContent(int resourceId) throws IOException {
        Timber.d((String)"Reading from resource ...", (Object[])new Object[0]);
        try (InputStream is = null;){
            is = this.context.getResources().openRawResource(resourceId);
            ByteBuffer byteBuffer = Utils.readFromInputStream(is);
            return byteBuffer;
        }
    }

    protected ServerResponse buildResourceContentResponse(int resourceId) {
        ServerResponse response = new ServerResponse();
        try {
            response.setResponse(this.readResourceContent(resourceId));
            response.setResponseStatus(200);
            response.setStatus(ServerResponse.NsStatus.OK);
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Error injecting response", (Object[])new Object[0]);
            response.setStatus(ServerResponse.NsStatus.ERROR_FAILURE);
        }
        return response;
    }

    public static interface Storage {
        public void put(String var1);

        public boolean contains(String var1);
    }

    public static interface Listener {
        public void onIntercepted(String var1, int var2);
    }

    public static class SharedPrefsStorage
    implements Storage {
        private static final String URLS = "urls";
        private SharedPreferences prefs;
        private Set<String> urls;

        public SharedPrefsStorage(SharedPreferences prefs) {
            this.prefs = prefs;
            this.urls = prefs.getStringSet(URLS, new HashSet());
        }

        @Override
        public synchronized void put(String url) {
            this.urls.add(url);
            this.prefs.edit().putStringSet(URLS, this.urls).commit();
        }

        @Override
        public synchronized boolean contains(String url) {
            return this.urls.contains(url);
        }
    }
}

