/*
 * Decompiled with CFR 0.152.
 */
package org.adblockplus.libadblockplus.android;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import timber.log.Timber;

public class ConnectionInputStream
extends InputStream {
    private final HttpURLConnection httpURLConnection;
    private boolean closed = false;
    private static final int CACHE_SIZE = 4096;
    private final BufferedInputStream bufferedInputStream;

    public ConnectionInputStream(InputStream inputStream, HttpURLConnection httpURLConnection) {
        this.httpURLConnection = httpURLConnection;
        this.bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        try {
            this.bufferedInputStream.mark(4097);
            this.bufferedInputStream.read(new byte[4096], 0, 4096);
            this.bufferedInputStream.reset();
        }
        catch (IOException e) {
            Timber.d((String)"Error while reading cached buffer for url %s and error %s", (Object[])new Object[]{httpURLConnection.getURL(), e.getMessage()});
        }
    }

    @Override
    public int read() throws IOException {
        return this.bufferedInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.bufferedInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bufferedInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bufferedInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.bufferedInputStream.available();
    }

    @Override
    public void close() throws IOException {
        try {
            Timber.d((String)"close()", (Object[])new Object[0]);
            this.bufferedInputStream.close();
            this.closed = true;
        }
        finally {
            this.httpURLConnection.disconnect();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.bufferedInputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.bufferedInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.bufferedInputStream.markSupported();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                Timber.d((String)"close() from finalize", (Object[])new Object[0]);
                this.httpURLConnection.disconnect();
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }
}

