/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.BroadcastGroupControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;

public class BroadcastGroupControlImpl
extends AbstractControl
implements BroadcastGroupControl {
    private final BroadcastGroup broadcastGroup;
    private final BroadcastGroupConfiguration configuration;

    public BroadcastGroupControlImpl(BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration) throws Exception {
        super(BroadcastGroupControl.class, storageManager);
        this.broadcastGroup = broadcastGroup;
        this.configuration = configuration;
    }

    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getBroadcastPeriod() {
        this.clearIO();
        try {
            long l = this.configuration.getBroadcastPeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getConnectorPairs() {
        this.clearIO();
        try {
            Object[] ret = new Object[this.configuration.getConnectorInfos().size()];
            int i = 0;
            for (String connector : this.configuration.getConnectorInfos()) {
                ret[i++] = connector;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getConnectorPairsAsJSON() throws Exception {
        this.clearIO();
        try {
            String string = JsonUtil.toJsonArray((List)this.configuration.getConnectorInfos()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getGroupAddress() throws Exception {
        this.clearIO();
        try {
            if (this.configuration.getEndpointFactory() instanceof UDPBroadcastEndpointFactory) {
                String string = ((UDPBroadcastEndpointFactory)this.configuration.getEndpointFactory()).getGroupAddress();
                return string;
            }
            throw new Exception("Invalid request because this is not a UDP Broadcast configuration.");
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getGroupPort() throws Exception {
        this.clearIO();
        try {
            if (this.configuration.getEndpointFactory() instanceof UDPBroadcastEndpointFactory) {
                int n = ((UDPBroadcastEndpointFactory)this.configuration.getEndpointFactory()).getGroupPort();
                return n;
            }
            throw new Exception("Invalid request because this is not a UDP Broadcast configuration.");
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getLocalBindPort() throws Exception {
        this.clearIO();
        try {
            if (this.configuration.getEndpointFactory() instanceof UDPBroadcastEndpointFactory) {
                int n = ((UDPBroadcastEndpointFactory)this.configuration.getEndpointFactory()).getLocalBindPort();
                return n;
            }
            throw new Exception("Invalid request because this is not a UDP Broadcast configuration.");
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.broadcastGroup.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void start() throws Exception {
        this.clearIO();
        try {
            this.broadcastGroup.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void stop() throws Exception {
        this.clearIO();
        try {
            this.broadcastGroup.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BroadcastGroupControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(BroadcastGroupControl.class);
    }
}

