/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;

public class ConsumerFilterPredicate
extends ActiveMQFilterPredicate<ServerConsumer> {
    private Field f;
    private final ActiveMQServer server;

    public ConsumerFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean apply(ServerConsumer consumer) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case ID: {
                return this.matches(consumer.getSequentialID());
            }
            case SESSION_ID: {
                return this.matches(consumer.getSessionID());
            }
            case USER: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getUsername());
            }
            case ADDRESS: {
                return this.matches(consumer.getQueue().getAddress());
            }
            case QUEUE: {
                return this.matches(consumer.getQueue().getName());
            }
            case PROTOCOL: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getProtocolName());
            }
            case CLIENT_ID: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getClientID());
            }
            case LOCAL_ADDRESS: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getTransportConnection().getLocalAddress());
            }
            case REMOTE_ADDRESS: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getTransportConnection().getRemoteAddress());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = Field.valueOf(field.toUpperCase());
        }
    }

    static enum Field {
        ID,
        SESSION_ID,
        QUEUE,
        ADDRESS,
        USER,
        PROTOCOL,
        CLIENT_ID,
        LOCAL_ADDRESS,
        REMOTE_ADDRESS;

    }
}

