/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;

public class MessageReferenceImpl
extends LinkedListImpl.Node<MessageReferenceImpl>
implements MessageReference {
    private final AtomicInteger deliveryCount = new AtomicInteger();
    private volatile int persistedCount;
    private volatile long scheduledDeliveryTime;
    private final Message message;
    private final Queue queue;
    private Long consumerID;
    private boolean alreadyAcked;
    private Object protocolData;
    private static final int memoryOffset = 64;

    public MessageReferenceImpl() {
        this.queue = null;
        this.message = null;
    }

    public MessageReferenceImpl(MessageReferenceImpl other, Queue queue) {
        this.deliveryCount.set(other.deliveryCount.get());
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
        this.message = other.message;
        this.queue = queue;
    }

    public MessageReferenceImpl(Message message, Queue queue) {
        this.message = message;
        this.queue = queue;
    }

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    @Override
    public int getPersistedCount() {
        return this.persistedCount;
    }

    @Override
    public void setPersistedCount(int persistedCount) {
        this.persistedCount = persistedCount;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new MessageReferenceImpl(this, queue);
    }

    public static int getMemoryEstimate() {
        return 64;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount.get();
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount.set(deliveryCount);
        this.persistedCount = this.deliveryCount.get();
    }

    @Override
    public void incrementDeliveryCount() {
        this.deliveryCount.incrementAndGet();
    }

    @Override
    public void decrementDeliveryCount() {
        this.deliveryCount.decrementAndGet();
    }

    @Override
    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.scheduledDeliveryTime = scheduledDeliveryTime;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public long getMessageID() {
        return this.getMessage().getMessageID();
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public void handled() {
        this.queue.referenceHandled(this);
    }

    @Override
    public void setAlreadyAcked() {
        this.alreadyAcked = true;
    }

    @Override
    public boolean isAlreadyAcked() {
        return this.alreadyAcked;
    }

    @Override
    public boolean isPaged() {
        return false;
    }

    @Override
    public void acknowledge() throws Exception {
        this.acknowledge(null);
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.acknowledge(tx, AckReason.NORMAL);
    }

    @Override
    public void acknowledge(Transaction tx, AckReason reason) throws Exception {
        if (tx == null) {
            this.getQueue().acknowledge(this, reason);
        } else {
            this.getQueue().acknowledge(tx, this, reason);
        }
    }

    @Override
    public void setConsumerId(Long consumerID) {
        this.consumerID = consumerID;
    }

    @Override
    public Long getConsumerId() {
        return this.consumerID;
    }

    @Override
    public int getMessageMemoryEstimate() {
        return this.message.getMemoryEstimate();
    }

    public String toString() {
        return "Reference[" + this.getMessage().getMessageID() + "]:" + (this.getMessage().isDurable() ? "RELIABLE" : "NON-RELIABLE") + ":" + this.getMessage();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MessageReferenceImpl) {
            MessageReferenceImpl reference = (MessageReferenceImpl)other;
            if (this.getMessage().equals(reference.getMessage())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getMessage().getPersistentSize();
    }
}

