/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.axis2.util.Utils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPSender
extends AbstractHTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSender.class);

    @Override
    public void send(MessageContext msgContext, URL url, String soapActionString) throws IOException {
        String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
        if (httpMethod != null) {
            if ("GET".equalsIgnoreCase(httpMethod)) {
                this.sendViaGet(msgContext, url, soapActionString);
                return;
            }
            if ("DELETE".equalsIgnoreCase(httpMethod)) {
                this.sendViaDelete(msgContext, url, soapActionString);
                return;
            }
            if ("PUT".equalsIgnoreCase(httpMethod)) {
                this.sendViaPut(msgContext, url, soapActionString);
                return;
            }
        }
        this.sendViaPost(msgContext, url, soapActionString);
    }

    private void sendViaGet(MessageContext msgContext, URL url, String soapActiionString) throws AxisFault {
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = this.getHttpClient(msgContext);
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpMethodBase)getMethod, httpClient, soapActiionString);
        String soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActiionString);
        if (soapAction != null && !msgContext.isDoingREST()) {
            getMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)getMethod);
            this.handleResponse(msgContext, (HttpMethodBase)getMethod);
        }
        catch (IOException e) {
            log.info((Object)("Unable to sendViaGet to url[" + url + "]"), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            this.cleanup(msgContext, (HttpMethod)getMethod);
        }
    }

    private void cleanup(MessageContext msgContext, HttpMethod method) {
        if (msgContext.isPropertyTrue("AutoReleaseConnection")) {
            log.trace((Object)("AutoReleasing " + method));
            method.releaseConnection();
        }
    }

    private void sendViaDelete(MessageContext msgContext, URL url, String soapActiionString) throws AxisFault {
        DeleteMethod deleteMethod = new DeleteMethod();
        HttpClient httpClient = this.getHttpClient(msgContext);
        this.populateCommonProperties(msgContext, url, (HttpMethodBase)deleteMethod, httpClient, soapActiionString);
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)deleteMethod);
            this.handleResponse(msgContext, (HttpMethodBase)deleteMethod);
        }
        catch (IOException e) {
            log.info((Object)("Unable to sendViaDelete to url[" + url + "]"), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            this.cleanup(msgContext, (HttpMethod)deleteMethod);
        }
    }

    private void sendViaPost(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        HttpClient httpClient = this.getHttpClient(msgContext);
        PostMethod postMethod = new PostMethod();
        if (log.isTraceEnabled()) {
            log.trace((Object)(Thread.currentThread() + " PostMethod " + postMethod + " / " + httpClient));
        }
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpMethodBase)postMethod, httpClient, soapActionString);
        postMethod.setRequestEntity((RequestEntity)new AxisRequestEntity(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            postMethod.setContentChunked(true);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null && !msgContext.isDoingREST()) {
            postMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)postMethod);
            this.handleResponse(msgContext, (HttpMethodBase)postMethod);
        }
        catch (IOException e) {
            log.info((Object)("Unable to sendViaPost to url[" + url + "]"), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            this.cleanup(msgContext, (HttpMethod)postMethod);
        }
    }

    private void sendViaPut(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        HttpClient httpClient = this.getHttpClient(msgContext);
        PutMethod putMethod = new PutMethod();
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpMethodBase)putMethod, httpClient, soapActionString);
        putMethod.setRequestEntity((RequestEntity)new AxisRequestEntity(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            putMethod.setContentChunked(true);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null && !msgContext.isDoingREST()) {
            putMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)putMethod);
            this.handleResponse(msgContext, (HttpMethodBase)putMethod);
        }
        catch (IOException e) {
            log.info((Object)("Unable to sendViaPut to url[" + url + "]"), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            this.cleanup(msgContext, (HttpMethod)putMethod);
        }
    }

    private void handleResponse(MessageContext msgContext, HttpMethodBase method) throws IOException {
        int statusCode = method.getStatusCode();
        HTTPStatusCodeFamily family = this.getHTTPStatusCodeFamily(statusCode);
        log.trace((Object)("Handling response - " + statusCode));
        Set nonErrorCodes = (Set)msgContext.getProperty("non.error.http.status.codes");
        HashSet<Integer> errorCodes = new HashSet<Integer>();
        String strRetryErrorCodes = (String)msgContext.getProperty("error.http.status.codes");
        if (strRetryErrorCodes != null && !strRetryErrorCodes.trim().equals("")) {
            for (String strRetryErrorCode : strRetryErrorCodes.split(",")) {
                try {
                    errorCodes.add(Integer.valueOf(strRetryErrorCode));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)(strRetryErrorCode + " is not a valid status code"));
                }
            }
        }
        if (statusCode == 202) {
            this.obtainHTTPHeaderInformation(method, msgContext);
            method.releaseConnection();
        } else if (HTTPStatusCodeFamily.SUCCESSFUL.equals((Object)family)) {
            msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
            this.processResponse(method, msgContext);
        } else if (!(errorCodes.contains(statusCode) || statusCode != 500 && statusCode != 400)) {
            MessageContext inMessageContext;
            OperationContext opContext;
            msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
            Header contenttypeHeader = method.getResponseHeader("Content-Type");
            String value = null;
            if (contenttypeHeader != null) {
                value = contenttypeHeader.getValue();
            }
            if ((opContext = msgContext.getOperationContext()) != null && (inMessageContext = opContext.getMessageContext("In")) != null) {
                inMessageContext.setProcessingFault(true);
            }
            if (value != null) {
                this.processResponse(method, msgContext);
            }
            if (Utils.isClientThreadNonBlockingPropertySet((MessageContext)msgContext)) {
                throw new AxisFault(Messages.getMessage((String)"transportError", (String)String.valueOf(statusCode), (String)method.getStatusText()));
            }
        } else {
            if (nonErrorCodes != null && nonErrorCodes.contains(statusCode)) {
                msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)method);
                this.processResponse(method, msgContext);
                return;
            }
            method.releaseConnection();
            throw new AxisFault(Messages.getMessage((String)"transportError", (String)String.valueOf(statusCode), (String)method.getStatusText()));
        }
    }

    protected HTTPStatusCodeFamily getHTTPStatusCodeFamily(int statusCode) {
        switch (statusCode / 100) {
            case 1: {
                return HTTPStatusCodeFamily.INFORMATIONAL;
            }
            case 2: {
                return HTTPStatusCodeFamily.SUCCESSFUL;
            }
            case 3: {
                return HTTPStatusCodeFamily.REDIRECTION;
            }
            case 4: {
                return HTTPStatusCodeFamily.CLIENT_ERROR;
            }
            case 5: {
                return HTTPStatusCodeFamily.SERVER_ERROR;
            }
        }
        return HTTPStatusCodeFamily.OTHER;
    }

    protected static enum HTTPStatusCodeFamily {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        OTHER;

    }
}

