/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EncodingUtils;
import org.apache.ws.commons.schema.XmlSchema;

public class HTTPWorker
implements Worker {
    @Override
    public void service(AxisHttpRequest request, AxisHttpResponse response, MessageContext msgContext) throws HttpException, IOException {
        Handler.InvocationResponse pi;
        String contentType;
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        String servicePath = configurationContext.getServiceContextPath();
        String contextPath = (servicePath.startsWith("/") ? servicePath : "/" + servicePath) + "/";
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String soapAction = HttpUtils.getSoapAction(request);
        if (method.equals("GET")) {
            int index;
            String serviceName;
            AxisService service;
            HashMap services;
            String serviceName2;
            if (uri.equals("/favicon.ico")) {
                response.setStatus(301);
                response.addHeader((Header)new BasicHeader("Location", "http://ws.apache.org/favicon.ico"));
                return;
            }
            if (!uri.startsWith(contextPath)) {
                response.setStatus(301);
                response.addHeader((Header)new BasicHeader("Location", contextPath));
                return;
            }
            if (uri.endsWith("axis2/services/")) {
                String s = HTTPTransportReceiver.getServicesHTML(configurationContext);
                response.setStatus(200);
                response.setContentType("text/html");
                OutputStream out = response.getOutputStream();
                out.write(EncodingUtils.getBytes((String)s, (String)"ISO-8859-1"));
                return;
            }
            if (uri.indexOf("?") < 0 && !uri.endsWith(contextPath) && (uri.endsWith(".xsd") || uri.endsWith(".wsdl"))) {
                HashMap services2 = configurationContext.getAxisConfiguration().getServices();
                String file = uri.substring(uri.lastIndexOf("/") + 1, uri.length());
                if (services2 != null && !services2.isEmpty()) {
                    for (AxisService service2 : services2.values()) {
                        InputStream stream = service2.getClassLoader().getResourceAsStream("META-INF/" + file);
                        if (stream == null) continue;
                        OutputStream out = response.getOutputStream();
                        response.setContentType("text/xml");
                        ListingAgent.copy(stream, out);
                        out.flush();
                        out.close();
                        return;
                    }
                }
            }
            if (uri.endsWith("?wsdl2")) {
                serviceName2 = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 6);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName2);
                if (service != null) {
                    boolean canExposeServiceMetadata = this.canExposeServiceMetadata(service);
                    if (canExposeServiceMetadata) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        service.printWSDL2(response.getOutputStream(), this.getHost(request));
                    } else {
                        response.setStatus(403);
                    }
                    return;
                }
            }
            if (uri.endsWith("?wsdl")) {
                AxisService service2;
                String[] temp = uri.split(configurationContext.getServiceContextPath() + "/");
                serviceName = temp[1].substring(0, temp[1].length() - 5);
                HashMap services3 = configurationContext.getAxisConfiguration().getServices();
                service2 = (AxisService)services3.get(serviceName);
                if (service2 != null) {
                    boolean canExposeServiceMetadata = this.canExposeServiceMetadata(service2);
                    if (canExposeServiceMetadata) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        service2.printWSDL(response.getOutputStream(), this.getHost(request));
                    } else {
                        response.setStatus(403);
                    }
                    return;
                }
            }
            if (uri.endsWith("?xsd")) {
                serviceName2 = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 4);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName2);
                if (service != null) {
                    boolean canExposeServiceMetadata = this.canExposeServiceMetadata(service);
                    if (canExposeServiceMetadata) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        service.printSchema(response.getOutputStream());
                    } else {
                        response.setStatus(403);
                    }
                    return;
                }
            }
            if (uri.indexOf("?xsd=") > 0) {
                String[] uriParts = uri.split("[?]xsd=");
                serviceName = uri.substring(uriParts[0].lastIndexOf("/") + 1, uriParts[0].length());
                String schemaName = uri.substring(uri.lastIndexOf("=") + 1);
                HashMap services4 = configurationContext.getAxisConfiguration().getServices();
                AxisService service3 = (AxisService)services4.get(serviceName);
                if (service3 != null) {
                    int dotIndex;
                    boolean canExposeServiceMetadata = this.canExposeServiceMetadata(service3);
                    if (!canExposeServiceMetadata) {
                        response.setStatus(403);
                        return;
                    }
                    service3.populateSchemaMappings();
                    Map schemaTable = service3.getSchemaMappingTable();
                    XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                        String schemaKey = schemaName.substring(0, dotIndex);
                        schema = (XmlSchema)schemaTable.get(schemaKey);
                    }
                    if (schema != null) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        schema.write(response.getOutputStream());
                        return;
                    }
                    InputStream instream = service3.getClassLoader().getResourceAsStream("META-INF/" + schemaName);
                    if (instream != null) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        OutputStream outstream = response.getOutputStream();
                        boolean checkLength = true;
                        int length = Integer.MAX_VALUE;
                        int nextValue = instream.read();
                        if (checkLength) {
                            --length;
                        }
                        while (-1 != nextValue && length >= 0) {
                            outstream.write(nextValue);
                            nextValue = instream.read();
                            if (!checkLength) continue;
                            --length;
                        }
                        outstream.flush();
                        return;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int ret = service3.printXSD((OutputStream)baos, schemaName);
                    if (ret > 0) {
                        baos.flush();
                        instream = new ByteArrayInputStream(baos.toByteArray());
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        OutputStream outstream = response.getOutputStream();
                        boolean checkLength = true;
                        int length = Integer.MAX_VALUE;
                        int nextValue = instream.read();
                        if (checkLength) {
                            --length;
                        }
                        while (-1 != nextValue && length >= 0) {
                            outstream.write(nextValue);
                            nextValue = instream.read();
                            if (!checkLength) continue;
                            --length;
                        }
                        outstream.flush();
                        return;
                    }
                    response.sendError(404, "Schema Not Found!");
                    return;
                }
            }
            if (uri.indexOf("?wsdl2=") > 0 && this.processInternalWSDL(uri, configurationContext, serviceName2 = uri.substring(uri.lastIndexOf("/") + 1, uri.lastIndexOf("?wsdl2=")), response, this.getHost(request))) {
                return;
            }
            if (uri.indexOf("?wsdl=") > 0 && this.processInternalWSDL(uri, configurationContext, serviceName2 = uri.substring(uri.lastIndexOf("/") + 1, uri.lastIndexOf("?wsdl=")), response, this.getHost(request))) {
                return;
            }
            contentType = null;
            Header[] headers = request.getHeaders("Content-Type");
            if (headers != null && headers.length > 0 && (index = (contentType = headers[0].getValue()).indexOf(59)) > 0) {
                contentType = contentType.substring(0, index);
            }
            pi = RESTUtil.processURLRequest(msgContext, response.getOutputStream(), contentType);
        } else if (method.equals("POST")) {
            contentType = request.getContentType();
            if (HTTPTransportUtils.isRESTRequest(contentType)) {
                pi = RESTUtil.processXMLRequest(msgContext, request.getInputStream(), response.getOutputStream(), contentType);
            } else {
                String ip = (String)msgContext.getProperty("TRANSPORT_ADDR");
                if (ip != null) {
                    uri = ip + uri;
                }
                pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, request.getInputStream(), response.getOutputStream(), contentType, soapAction, uri);
            }
        } else if (method.equals("PUT")) {
            contentType = request.getContentType();
            msgContext.setProperty("ContentType", (Object)contentType);
            pi = RESTUtil.processXMLRequest(msgContext, request.getInputStream(), response.getOutputStream(), contentType);
        } else if (method.equals("DELETE")) {
            pi = RESTUtil.processURLRequest(msgContext, response.getOutputStream(), null);
        } else {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
        if (pi.equals((Object)Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
            try {
                ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).awaitResponse();
            }
            catch (InterruptedException e) {
                throw new IOException("We were interrupted, so this may not function correctly:" + e.getMessage());
            }
        }
        RequestResponseTransport requestResponseTransportControl = (RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl");
        if (!(TransportUtils.isResponseWritten((MessageContext)msgContext) || requestResponseTransportControl != null && requestResponseTransportControl.getStatus().equals((Object)RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED))) {
            response.setStatus(202);
        }
    }

    private boolean canExposeServiceMetadata(AxisService service) throws IOException {
        Parameter exposeServiceMetadata = service.getParameter("exposeServiceMetadata");
        return exposeServiceMetadata == null || !JavaUtils.isFalseExplicitly((Object)exposeServiceMetadata.getValue());
    }

    private boolean processInternalWSDL(String uri, ConfigurationContext configurationContext, String serviceName, AxisHttpResponse response, String ip) throws IOException {
        String wsdlName = uri.substring(uri.lastIndexOf("=") + 1);
        HashMap services = configurationContext.getAxisConfiguration().getServices();
        AxisService service = (AxisService)services.get(serviceName);
        if (service != null) {
            response.setStatus(200);
            response.setContentType("text/xml");
            service.printUserWSDL(response.getOutputStream(), wsdlName, ip);
            response.getOutputStream().flush();
            return true;
        }
        response.sendError(404, "Schema Not Found!");
        return true;
    }

    public String getHost(AxisHttpRequest request) throws SocketException {
        String[] parts;
        String host = null;
        Header hostHeader = request.getFirstHeader("host");
        if (hostHeader != null && (parts = hostHeader.getValue().split("[:]")).length > 0) {
            host = parts[0].trim();
        }
        return host;
    }
}

