/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.ConvertersFromResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ConvertersResource
extends CamelChildResourceSupport {
    public ConvertersResource(CamelContextResource contextResource) {
        super(contextResource);
    }

    public Map<String, Class<?>> getFromClassTypes() {
        TreeMap answer = new TreeMap();
        DefaultTypeConverter converter = this.getDefaultTypeConverter();
        if (converter != null) {
            Set classes = converter.getFromClassMappings();
            for (Class aClass : classes) {
                String name = ConvertersResource.nameOf((Class)aClass);
                answer.put(name, aClass);
            }
        }
        return answer;
    }

    @Path(value="{type}")
    public ConvertersFromResource getConvertersFrom(@PathParam(value="type") String typeName) {
        Class type = this.getCamelContext().getClassResolver().resolveClass(typeName, this.getClass().getClassLoader());
        if (type == null) {
            return null;
        }
        return new ConvertersFromResource(this.getContextResource(), type);
    }

    public static String nameOf(Class<?> aClass) {
        return aClass.getCanonicalName();
    }
}

