/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class Swagger2Customizer {
    protected boolean dynamicBasePath;
    protected boolean replaceTags;
    protected boolean applyDefaultVersion = true;
    protected DocumentationProvider javadocProvider;
    protected List<ClassResourceInfo> cris;
    protected BeanConfig beanConfig;

    public Swagger customize(Swagger data) {
        if (this.dynamicBasePath) {
            MessageContext ctx = this.createMessageContext();
            String currentBasePath = StringUtils.substringBeforeLast((String)ctx.getHttpServletRequest().getRequestURI(), (String)"/");
            data.setBasePath(currentBasePath);
            if (data.getHost() == null) {
                data.setHost(this.beanConfig.getHost());
            }
            if (data.getInfo() == null) {
                data.setInfo(this.beanConfig.getInfo());
            }
            if (this.beanConfig.getSwagger() != null && this.beanConfig.getSwagger().getSecurityDefinitions() != null && data.getSecurityDefinitions() == null) {
                data.setSecurityDefinitions(this.beanConfig.getSwagger().getSecurityDefinitions());
            }
        }
        if (this.replaceTags || this.javadocProvider != null) {
            HashMap<String, ClassResourceInfo> operations = new HashMap<String, ClassResourceInfo>();
            HashMap<ImmutablePair, OperationResourceInfo> methods = new HashMap<ImmutablePair, OperationResourceInfo>();
            for (ClassResourceInfo classResourceInfo : this.cris) {
                for (OperationResourceInfo ori : classResourceInfo.getMethodDispatcher().getOperationResourceInfos()) {
                    String normalizedPath = this.getNormalizedPath(classResourceInfo.getURITemplate().getValue(), ori.getURITemplate().getValue());
                    operations.put(normalizedPath, classResourceInfo);
                    methods.put(ImmutablePair.of((Object)ori.getHttpMethod(), (Object)normalizedPath), ori);
                }
            }
            if (this.replaceTags && data.getTags() != null) {
                data.getTags().clear();
            }
            for (Map.Entry entry : data.getPaths().entrySet()) {
                Tag tag = null;
                if (this.replaceTags && operations.containsKey(entry.getKey())) {
                    ClassResourceInfo cri = (ClassResourceInfo)operations.get(entry.getKey());
                    tag = new Tag();
                    tag.setName(cri.getURITemplate().getValue().replaceAll("/", "_"));
                    if (this.javadocProvider != null) {
                        tag.setDescription(this.javadocProvider.getClassDoc(cri));
                    }
                    data.addTag(tag);
                }
                for (Map.Entry subentry : ((Path)entry.getValue()).getOperationMap().entrySet()) {
                    ImmutablePair key;
                    if (this.replaceTags && tag != null) {
                        ((Operation)subentry.getValue()).setTags(Collections.singletonList(tag.getName()));
                    }
                    if (!methods.containsKey(key = ImmutablePair.of((Object)((HttpMethod)subentry.getKey()).name(), entry.getKey())) || this.javadocProvider == null) continue;
                    OperationResourceInfo ori = (OperationResourceInfo)methods.get(key);
                    ((Operation)subentry.getValue()).setSummary(this.javadocProvider.getMethodDoc(ori));
                    for (int i = 0; i < ((Operation)subentry.getValue()).getParameters().size(); ++i) {
                        ((Parameter)((Operation)subentry.getValue()).getParameters().get(i)).setDescription(this.javadocProvider.getMethodParameterDoc(ori, i));
                    }
                    this.addParameters(((Operation)subentry.getValue()).getParameters());
                    if (((Operation)subentry.getValue()).getResponses() == null || ((Operation)subentry.getValue()).getResponses().isEmpty()) continue;
                    ((Response)((Operation)subentry.getValue()).getResponses().entrySet().iterator().next().getValue()).setDescription(this.javadocProvider.getMethodResponseDoc(ori));
                }
            }
        }
        if (this.replaceTags && data.getTags() != null) {
            Collections.sort(data.getTags(), new Comparator<Tag>(){

                @Override
                public int compare(Tag tag1, Tag tag2) {
                    return tag1.getName().compareTo(tag2.getName());
                }
            });
        }
        this.applyDefaultVersion(data);
        return data;
    }

    private MessageContext createMessageContext() {
        return (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
    }

    protected String getNormalizedPath(String classResourcePath, String operationResourcePath) {
        String[] segments;
        StringBuilder normalizedPath = new StringBuilder();
        for (String segment : segments = (classResourcePath + operationResourcePath).split("/")) {
            if (StringUtils.isEmpty((CharSequence)segment)) continue;
            normalizedPath.append('/').append(segment);
        }
        if (normalizedPath.toString().endsWith(":.*}")) {
            normalizedPath.setLength(normalizedPath.length() - 4);
            normalizedPath.append('}');
        }
        return "".equals(normalizedPath.toString()) ? "/" : normalizedPath.toString();
    }

    protected void applyDefaultVersion(Swagger data) {
        Package resourcePackage;
        if (this.applyDefaultVersion && data.getInfo() != null && data.getInfo().getVersion() == null && this.beanConfig != null && this.beanConfig.getResourcePackage() != null && (resourcePackage = Package.getPackage(this.beanConfig.getResourcePackage())) != null) {
            data.getInfo().setVersion(resourcePackage.getImplementationVersion());
        }
    }

    protected void addParameters(List<Parameter> parameters) {
    }

    public void setDynamicBasePath(boolean dynamicBasePath) {
        this.dynamicBasePath = dynamicBasePath;
    }

    public void setReplaceTags(boolean replaceTags) {
        this.replaceTags = replaceTags;
    }

    public void setJavadocProvider(DocumentationProvider javadocProvider) {
        this.javadocProvider = javadocProvider;
    }

    public void setClassResourceInfos(List<ClassResourceInfo> classResourceInfos) {
        this.cris = classResourceInfos;
    }

    public void setJavaDocPath(String javaDocPath) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPath);
    }

    public void setJavaDocPaths(String ... javaDocPaths) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPaths);
    }

    public void setJavaDocURLs(URL[] javaDocURLs) {
        this.javadocProvider = new JavaDocProvider(javaDocURLs);
    }

    public void setBeanConfig(BeanConfig beanConfig) {
        this.beanConfig = beanConfig;
    }

    public void setApplyDefaultVersion(boolean applyDefaultVersion) {
        this.applyDefaultVersion = applyDefaultVersion;
    }
}

