/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class RevisionResolver {
    private static final Logger logger = LoggerFactory.getLogger(RevisionResolver.class);
    public static final String EMPTY_REVISION = "0";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessageDigest mdInst;

    public static String calRevision(String metadata) {
        mdInst.update(metadata.getBytes(StandardCharsets.UTF_8));
        byte[] md5 = mdInst.digest();
        int j = md5.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md5[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static String getEmptyRevision(String app) {
        return EMPTY_REVISION;
    }

    static {
        try {
            mdInst = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to calculate metadata revision", (Throwable)e);
        }
    }
}

