/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.ml.classification.SVM;
import org.apache.flink.ml.classification.SVM$;
import org.apache.flink.ml.classification.SVM$$anon$25$;
import org.apache.flink.ml.classification.SVM$Blocks$;
import org.apache.flink.ml.classification.SVM$Iterations$;
import org.apache.flink.ml.classification.SVM$LocalIterations$;
import org.apache.flink.ml.classification.SVM$OutputDecisionFunction$;
import org.apache.flink.ml.classification.SVM$Regularization$;
import org.apache.flink.ml.classification.SVM$Seed$;
import org.apache.flink.ml.classification.SVM$Stepsize$;
import org.apache.flink.ml.classification.SVM$ThresholdValue$;
import org.apache.flink.ml.common.Block;
import org.apache.flink.ml.common.FlinkMLTools$;
import org.apache.flink.ml.common.FlinkMLTools$ModuloKeyPartitioner$;
import org.apache.flink.ml.common.LabeledVector;
import org.apache.flink.ml.common.ParameterMap;
import org.apache.flink.ml.math.Breeze$;
import org.apache.flink.ml.math.DenseVector$;
import org.apache.flink.ml.pipeline.FitOperation;
import org.apache.flink.ml.pipeline.PredictOperation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class SVM$ {
    public static final SVM$ MODULE$;
    private final String WEIGHT_VECTOR_BROADCAST_NAME;
    private final Object fitSVM;

    static {
        new SVM$();
    }

    public String WEIGHT_VECTOR_BROADCAST_NAME() {
        return this.WEIGHT_VECTOR_BROADCAST_NAME;
    }

    public SVM apply() {
        return new SVM();
    }

    public <T extends org.apache.flink.ml.math.Vector> Object predictVectors() {
        return new PredictOperation<SVM, org.apache.flink.ml.math.DenseVector, T, Object>(){
            private double thresholdValue;
            private boolean outputDecisionFunction;

            public double thresholdValue() {
                return this.thresholdValue;
            }

            public void thresholdValue_$eq(double x$1) {
                this.thresholdValue = x$1;
            }

            public boolean outputDecisionFunction() {
                return this.outputDecisionFunction;
            }

            public void outputDecisionFunction_$eq(boolean x$1) {
                this.outputDecisionFunction = x$1;
            }

            public DataSet<org.apache.flink.ml.math.DenseVector> getModel(SVM self, ParameterMap predictParameters) {
                this.thresholdValue_$eq(BoxesRunTime.unboxToDouble((Object)predictParameters.apply(SVM$ThresholdValue$.MODULE$)));
                this.outputDecisionFunction_$eq(BoxesRunTime.unboxToBoolean((Object)predictParameters.apply(SVM$OutputDecisionFunction$.MODULE$)));
                Option<DataSet<org.apache.flink.ml.math.DenseVector>> option = self.weightsOption();
                if (option instanceof Some) {
                    DataSet model;
                    Some some = (Some)option;
                    DataSet dataSet = model = (DataSet)some.x();
                    return dataSet;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException("The SVM model has not been trained. Call first fitbefore calling the predict operation.");
                }
                throw new MatchError(option);
            }

            public double predict(T value, org.apache.flink.ml.math.DenseVector model) {
                double rawValue = BoxesRunTime.unboxToDouble((Object)Breeze$.MODULE$.Vector2BreezeConverter((org.apache.flink.ml.math.Vector)value).asBreeze().dot(Breeze$.MODULE$.Vector2BreezeConverter(model).asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()));
                return this.outputDecisionFunction() ? rawValue : (rawValue > this.thresholdValue() ? 1.0 : -1.0);
            }
        };
    }

    public Object fitSVM() {
        return this.fitSVM;
    }

    public DataSet<DenseVector<Object>> org$apache$flink$ml$classification$SVM$$createInitialWeights(DataSet<Object> dimension) {
        return dimension.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(int d) {
                return breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(d, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            }
        }, TypeExtractor.createTypeInfo(DenseVector.class), ClassTag$.MODULE$.apply(DenseVector.class));
    }

    public DataSet<DenseVector<Object>> org$apache$flink$ml$classification$SVM$$localDualMethod(DataSet<DenseVector<Object>> w, DataSet<Tuple2<Block<LabeledVector>, Object>> blockedInputNumberElements, int localIterations, double regularization, double scaling, long seed) {
        RichMapFunction<Tuple2<Block<LabeledVector>, Object>, DenseVector<Object>> localSDCA = new RichMapFunction<Tuple2<Block<LabeledVector>, Object>, DenseVector<Object>>(localIterations, regularization, scaling, seed){
            private DenseVector<Object> originalW;
            private final ArrayBuffer<DenseVector<Object>> alphasArray;
            private final HashMap<Object, Object> idMapping;
            private int counter;
            private Random r;
            private final int localIterations$2;
            public final double regularization$2;
            private final double scaling$2;
            private final long seed$2;

            public DenseVector<Object> originalW() {
                return this.originalW;
            }

            public void originalW_$eq(DenseVector<Object> x$1) {
                this.originalW = x$1;
            }

            public ArrayBuffer<DenseVector<Object>> alphasArray() {
                return this.alphasArray;
            }

            public HashMap<Object, Object> idMapping() {
                return this.idMapping;
            }

            public int counter() {
                return this.counter;
            }

            public void counter_$eq(int x$1) {
                this.counter = x$1;
            }

            public Random r() {
                return this.r;
            }

            public void r_$eq(Random x$1) {
                this.r = x$1;
            }

            public void open(Configuration parameters) {
                this.originalW_$eq((DenseVector<Object>)((DenseVector)this.getRuntimeContext().getBroadcastVariable(SVM$.MODULE$.WEIGHT_VECTOR_BROADCAST_NAME()).get(0)));
                if (this.r() == null) {
                    this.r_$eq(new Random(this.seed$2 ^ (long)this.getRuntimeContext().getIndexOfThisSubtask()));
                }
            }

            public DenseVector<Object> map(Tuple2<Block<LabeledVector>, Object> blockNumberElements) {
                Tuple2<Block<LabeledVector>, Object> tuple2;
                block2: {
                    Option option;
                    block5: {
                        int n;
                        int numberElements;
                        Block block2;
                        block4: {
                            block3: {
                                int idx;
                                Tuple2 tuple22;
                                tuple2 = blockNumberElements;
                                if (tuple2 == null) break block2;
                                Block block3 = (Block)tuple2._1();
                                int numberElements2 = tuple2._2$mcI$sp();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)block3, (Object)BoxesRunTime.boxToInteger((int)numberElements2));
                                block2 = (Block)tuple23._1();
                                numberElements = tuple23._2$mcI$sp();
                                option = this.idMapping().get((Object)BoxesRunTime.boxToInteger((int)block2.index()));
                                if (!(option instanceof Some)) break block3;
                                Some some = (Some)option;
                                n = idx = BoxesRunTime.unboxToInt((Object)some.x());
                                break block4;
                            }
                            if (!None$.MODULE$.equals(option)) break block5;
                            this.idMapping().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)block2.index())), (Object)BoxesRunTime.boxToInteger((int)this.counter())));
                            this.counter_$eq(this.counter() + 1);
                            this.alphasArray().$plus$eq((Object)breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(block2.values().length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
                            n = this.counter() - 1;
                        }
                        int localIndex = n;
                        DenseVector tempAlphas = ((DenseVector)this.alphasArray().apply(localIndex)).copy$mcD$sp();
                        int numLocalDatapoints = tempAlphas.length();
                        DenseVector deltaAlphas = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(numLocalDatapoints, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                        DenseVector w = this.originalW().copy$mcD$sp();
                        DenseVector deltaW = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(this.originalW().length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.localIterations$2).foreach((Function1)new Serializable(this, block2, numberElements, tempAlphas, numLocalDatapoints, deltaAlphas, w, deltaW){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.10 $outer;
                            private final Block block$1;
                            private final int numberElements$1;
                            private final DenseVector tempAlphas$1;
                            private final int numLocalDatapoints$1;
                            private final DenseVector deltaAlphas$1;
                            private final DenseVector w$1;
                            private final DenseVector deltaW$1;

                            public final DenseVector<Object> apply(int i) {
                                int idx = this.$outer.r().nextInt(this.numLocalDatapoints$1);
                                LabeledVector labeledVector = (LabeledVector)this.block$1.values().apply(idx);
                                if (labeledVector != null) {
                                    Tuple2 tuple2;
                                    double label = labeledVector.label();
                                    org.apache.flink.ml.math.Vector vector = labeledVector.vector();
                                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)label), (Object)vector);
                                    double label2 = tuple22._1$mcD$sp();
                                    org.apache.flink.ml.math.Vector vector2 = (org.apache.flink.ml.math.Vector)tuple22._2();
                                    double alpha = this.tempAlphas$1.apply$mcD$sp(idx);
                                    Tuple2<Object, Vector<Object>> tuple23 = SVM$.MODULE$.org$apache$flink$ml$classification$SVM$$maximize(Breeze$.MODULE$.Vector2BreezeConverter(vector2).asBreeze(), label2, this.$outer.regularization$2, alpha, (Vector<Object>)this.w$1, this.numberElements$1);
                                    if (tuple23 != null) {
                                        Tuple2 tuple24;
                                        double deltaAlpha = tuple23._1$mcD$sp();
                                        Vector deltaWUpdate = (Vector)tuple23._2();
                                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)deltaAlpha), (Object)deltaWUpdate);
                                        double deltaAlpha2 = tuple25._1$mcD$sp();
                                        Vector deltaWUpdate2 = (Vector)tuple25._2();
                                        this.tempAlphas$1.update$mcD$sp(idx, this.tempAlphas$1.apply$mcD$sp(idx) + deltaAlpha2);
                                        this.deltaAlphas$1.update$mcD$sp(idx, this.deltaAlphas$1.apply$mcD$sp(idx) + deltaAlpha2);
                                        this.w$1.$plus$eq((Object)deltaWUpdate2, (UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
                                        return (DenseVector)this.deltaW$1.$plus$eq((Object)deltaWUpdate2, (UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
                                    }
                                    throw new MatchError(tuple23);
                                }
                                throw new MatchError((Object)labeledVector);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.block$1 = block$1;
                                this.numberElements$1 = numberElements$1;
                                this.tempAlphas$1 = tempAlphas$1;
                                this.numLocalDatapoints$1 = numLocalDatapoints$1;
                                this.deltaAlphas$1 = deltaAlphas$1;
                                this.w$1 = w$1;
                                this.deltaW$1 = deltaW$1;
                            }
                        });
                        ((NumericOps)this.alphasArray().apply(localIndex)).$plus$eq(deltaAlphas.$times((Object)BoxesRunTime.boxToDouble((double)this.scaling$2), breeze.linalg.DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix()), breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
                        return deltaW;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.localIterations$2 = localIterations$2;
                this.regularization$2 = regularization$2;
                this.scaling$2 = scaling$2;
                this.seed$2 = seed$2;
                this.alphasArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.idMapping = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.counter = 0;
            }
        };
        return blockedInputNumberElements.map((MapFunction)localSDCA, TypeExtractor.createTypeInfo(DenseVector.class), ClassTag$.MODULE$.apply(DenseVector.class)).withBroadcastSet(w, this.WEIGHT_VECTOR_BROADCAST_NAME());
    }

    public Tuple2<Object, Vector<Object>> org$apache$flink$ml$classification$SVM$$maximize(Vector<Object> x, double y, double regularization, double alpha, Vector<Object> w, int numberElements) {
        Tuple2 tuple2;
        double proj_grad;
        double dotProduct = BoxesRunTime.unboxToDouble((Object)x.dot(w, (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()));
        double grad = (y * dotProduct - 1.0) * (regularization * (double)numberElements);
        double d = alpha <= 0.0 ? package$.MODULE$.min(grad, 0.0) : (proj_grad = alpha >= 1.0 ? package$.MODULE$.max(grad, 0.0) : grad);
        if (package$.MODULE$.abs(grad) != 0.0) {
            double qii = BoxesRunTime.unboxToDouble((Object)x.dot(x, (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()));
            double newAlpha = qii != 0.0 ? package$.MODULE$.min(package$.MODULE$.max(alpha - grad / qii, 0.0), 1.0) : 1.0;
            Vector deltaW = (Vector)((ImmutableNumericOps)((ImmutableNumericOps)x.$times((Object)BoxesRunTime.boxToDouble((double)y), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())).$times((Object)BoxesRunTime.boxToDouble((double)(newAlpha - alpha)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())).$div((Object)BoxesRunTime.boxToDouble((double)(regularization * (double)numberElements)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)(newAlpha - alpha)), (Object)deltaW);
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)Vector$.MODULE$.zeros(w.length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        }
        return tuple2;
    }

    private SVM$() {
        MODULE$ = this;
        this.WEIGHT_VECTOR_BROADCAST_NAME = "weightVector";
        this.fitSVM = new FitOperation<SVM, LabeledVector>(){

            public void fit(SVM instance, ParameterMap fitParameters, DataSet<LabeledVector> input) {
                Option<Object> option;
                block4: {
                    int n;
                    ParameterMap resultingParameters;
                    block3: {
                        block2: {
                            int value;
                            resultingParameters = instance.parameters().$plus$plus(fitParameters);
                            option = resultingParameters.get(SVM$Blocks$.MODULE$);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            n = value = BoxesRunTime.unboxToInt((Object)some.x());
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        n = input.getParallelism();
                    }
                    int blocks = n;
                    double scaling = BoxesRunTime.unboxToDouble((Object)resultingParameters.apply(SVM$Stepsize$.MODULE$)) / (double)blocks;
                    int iterations = BoxesRunTime.unboxToInt((Object)resultingParameters.apply(SVM$Iterations$.MODULE$));
                    int localIterations = BoxesRunTime.unboxToInt((Object)resultingParameters.apply(SVM$LocalIterations$.MODULE$));
                    double regularization = BoxesRunTime.unboxToDouble((Object)resultingParameters.apply(SVM$Regularization$.MODULE$));
                    long seed = BoxesRunTime.unboxToLong((Object)resultingParameters.apply(SVM$Seed$.MODULE$));
                    DataSet dimension = input.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(LabeledVector x$1) {
                            return x$1.vector().size();
                        }
                    }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int()).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(int a, int b) {
                            return this.apply$mcIII$sp(a, b);
                        }

                        public int apply$mcIII$sp(int a, int b) {
                            Predef$.MODULE$.require(a == b, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Dimensions of feature vectors have to be equal.";
                                }
                            });
                            return a;
                        }
                    });
                    DataSet<DenseVector<Object>> initialWeights = SVM$.MODULE$.org$apache$flink$ml$classification$SVM$$createInitialWeights((DataSet<Object>)dimension);
                    DataSet numberVectors = input.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(LabeledVector x) {
                            return 1;
                        }
                    }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int()).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(int x$2, int x$3) {
                            return this.apply$mcIII$sp(x$2, x$3);
                        }

                        public int apply$mcIII$sp(int x$2, int x$3) {
                            return x$2 + x$3;
                        }
                    });
                    DataSet blockedInputNumberElements = FlinkMLTools$.MODULE$.block(input, blocks, (Option<Partitioner<Object>>)new Some((Object)FlinkMLTools$ModuloKeyPartitioner$.MODULE$), new CaseClassTypeInfo<LabeledVector>(this){

                        public /* synthetic */ TypeInformation[] protected$types(anon$25$$anon$11 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<LabeledVector> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$25$$anon$11 $outer;
                                private final ExecutionConfig executionConfig$1;
                                private final TypeSerializer[] fieldSerializers$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$1 = executionConfig$1;
                                    this.fieldSerializers$1 = fieldSerializers$1;
                                }
                            });
                            return new CaseClassSerializer<LabeledVector>(this, fieldSerializers){

                                public LabeledVector createInstance(Object[] fields) {
                                    return new LabeledVector(BoxesRunTime.unboxToDouble((Object)fields[0]), (org.apache.flink.ml.math.Vector)fields[1]);
                                }

                                public CaseClassSerializer<LabeledVector> createSerializerInstance(Class<LabeledVector> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                                    return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(LabeledVector.class)).cross(numberVectors).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Block<LabeledVector>, Object> apply(Tuple2<Block<LabeledVector>, Object> x) {
                            return x;
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Block<LabeledVector>, Object>>(this){

                        public /* synthetic */ TypeInformation[] protected$types(anon$25$$anon$12 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<Tuple2<Block<LabeledVector>, Object>> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$25$$anon$12 $outer;
                                private final ExecutionConfig executionConfig$2;
                                private final TypeSerializer[] fieldSerializers$8;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$2 = executionConfig$2;
                                    this.fieldSerializers$8 = fieldSerializers$8;
                                }
                            });
                            return new CaseClassSerializer<Tuple2<Block<LabeledVector>, Object>>(this, fieldSerializers){

                                public Tuple2<Block<LabeledVector>, Object> createInstance(Object[] fields) {
                                    return new Tuple2((Object)((Block)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                                }

                                public CaseClassSerializer<Tuple2<Block<LabeledVector>, Object>> createSerializerInstance(Class<Tuple2<Block<LabeledVector>, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                                    return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    DataSet resultingWeights = initialWeights.iterate(iterations, (Function1)new Serializable(this, scaling, localIterations, regularization, seed, blockedInputNumberElements){
                        public static final long serialVersionUID = 0L;
                        public final double scaling$1;
                        private final int localIterations$1;
                        private final double regularization$1;
                        private final long seed$1;
                        private final DataSet blockedInputNumberElements$1;

                        public final DataSet<DenseVector<Object>> apply(DataSet<DenseVector<Object>> weights) {
                            DataSet<DenseVector<Object>> deltaWs = SVM$.MODULE$.org$apache$flink$ml$classification$SVM$$localDualMethod(weights, (DataSet<Tuple2<Block<LabeledVector>, Object>>)this.blockedInputNumberElements$1, this.localIterations$1, this.regularization$1, this.scaling$1, this.seed$1);
                            DataSet weightedDeltaWs = deltaWs.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$25$$anonfun$6 $outer;

                                public final DenseVector<Object> apply(DenseVector<Object> deltaW) {
                                    return (DenseVector)deltaW.$colon$times$eq((Object)BoxesRunTime.boxToDouble((double)this.$outer.scaling$1), breeze.linalg.DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpMulScalar());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, TypeExtractor.createTypeInfo(DenseVector.class), ClassTag$.MODULE$.apply(DenseVector.class));
                            return weights.union(weightedDeltaWs).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DenseVector<Object> apply(DenseVector<Object> x$4, DenseVector<Object> x$5) {
                                    return (DenseVector)x$4.$plus(x$5, breeze.linalg.DenseVector$.MODULE$.canAddD());
                                }
                            });
                        }
                        {
                            this.scaling$1 = scaling$1;
                            this.localIterations$1 = localIterations$1;
                            this.regularization$1 = regularization$1;
                            this.seed$1 = seed$1;
                            this.blockedInputNumberElements$1 = blockedInputNumberElements$1;
                        }
                    });
                    instance.weightsOption_$eq((Option<DataSet<org.apache.flink.ml.math.DenseVector>>)new Some((Object)resultingWeights.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final org.apache.flink.ml.math.DenseVector apply(DenseVector<Object> x$6) {
                            return (org.apache.flink.ml.math.DenseVector)Breeze$.MODULE$.Breeze2VectorConverter((Vector<Object>)x$6).fromBreeze(DenseVector$.MODULE$.denseVectorConverter());
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<org.apache.flink.ml.math.DenseVector>(this){

                        public /* synthetic */ TypeInformation[] protected$types(anon$25$$anon$21 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<org.apache.flink.ml.math.DenseVector> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$25$$anon$21 $outer;
                                private final ExecutionConfig executionConfig$11;
                                private final TypeSerializer[] fieldSerializers$9;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$9[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$11);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$11 = executionConfig$11;
                                    this.fieldSerializers$9 = fieldSerializers$9;
                                }
                            });
                            return new CaseClassSerializer<org.apache.flink.ml.math.DenseVector>(this, fieldSerializers){

                                public org.apache.flink.ml.math.DenseVector createInstance(Object[] fields) {
                                    return new org.apache.flink.ml.math.DenseVector((double[])fields[0]);
                                }

                                public CaseClassSerializer<org.apache.flink.ml.math.DenseVector> createSerializerInstance(Class<org.apache.flink.ml.math.DenseVector> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                                    return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(org.apache.flink.ml.math.DenseVector.class))));
                    return;
                }
                throw new MatchError(option);
            }
        };
    }
}

