/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerCleanupTest;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobCache;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BlobCachePutTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testTransientBlobCacheGetStorageLocationConcurrentNoJob() throws Exception {
        this.testTransientBlobCacheGetStorageLocationConcurrent(null);
    }

    @Test
    public void testTransientBlobCacheGetStorageLocationConcurrentForJob() throws Exception {
        this.testTransientBlobCacheGetStorageLocationConcurrent(new JobID());
    }

    private void testTransientBlobCacheGetStorageLocationConcurrent(@Nullable JobID jobId) throws Exception {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             TransientBlobCache cache = new TransientBlobCache(new InetSocketAddress("localhost", server.getPort()), config);){
            server.start();
            TransientBlobKey key = new TransientBlobKey();
            CheckedThread[] threads = new CheckedThread[]{new TransientBlobCacheGetStorageLocation(cache, jobId, (BlobKey)key), new TransientBlobCacheGetStorageLocation(cache, jobId, (BlobKey)key), new TransientBlobCacheGetStorageLocation(cache, jobId, (BlobKey)key)};
            this.checkedThreadSimpleTest(threads);
        }
    }

    @Test
    public void testPermanentBlobCacheGetStorageLocationConcurrentForJob() throws Exception {
        JobID jobId = new JobID();
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             PermanentBlobCache cache = new PermanentBlobCache(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            PermanentBlobKey key = new PermanentBlobKey();
            CheckedThread[] threads = new CheckedThread[]{new PermanentBlobCacheGetStorageLocation(cache, jobId, (BlobKey)key), new PermanentBlobCacheGetStorageLocation(cache, jobId, (BlobKey)key), new PermanentBlobCacheGetStorageLocation(cache, jobId, (BlobKey)key)};
            this.checkedThreadSimpleTest(threads);
        }
    }

    private void checkedThreadSimpleTest(CheckedThread[] threads) throws Exception {
        for (CheckedThread t : threads) {
            t.start();
        }
        for (CheckedThread t : threads) {
            t.sync();
        }
    }

    @Test
    public void testPutBufferTransientSuccessfulGet1() throws IOException, InterruptedException {
        this.testPutBufferSuccessfulGet(null, null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferTransientSuccessfulGet2() throws IOException, InterruptedException {
        this.testPutBufferSuccessfulGet(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferTransientSuccessfulGet3() throws IOException, InterruptedException {
        this.testPutBufferSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferTransientSuccessfulGet4() throws IOException, InterruptedException {
        this.testPutBufferSuccessfulGet(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferPermanentSuccessfulGet() throws IOException, InterruptedException {
        this.testPutBufferSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testPutBufferSuccessfulGet(@Nullable JobID jobId1, @Nullable JobID jobId2, BlobKey.BlobType blobType) throws IOException, InterruptedException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOfRange(data, 10, 54);
            BlobKey key1a = BlobServerPutTest.put((BlobService)cache, jobId1, data, blobType);
            Assert.assertNotNull((Object)key1a);
            BlobKeyTest.verifyType(blobType, key1a);
            BlobKey key1a2 = BlobServerPutTest.put((BlobService)cache, jobId1, data, blobType);
            Assert.assertNotNull((Object)key1a2);
            BlobKeyTest.verifyType(blobType, key1a2);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key1a2);
            BlobKey key1b = BlobServerPutTest.put((BlobService)cache, jobId1, data2, blobType);
            Assert.assertNotNull((Object)key1b);
            BlobKeyTest.verifyType(blobType, key1b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobKey key2a = BlobServerPutTest.put((BlobService)cache, jobId2, data, blobType);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyType(blobType, key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key2a);
            BlobKey key2b = BlobServerPutTest.put((BlobService)cache, jobId2, data2, blobType);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyType(blobType, key2b);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1b, key2b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, key2b, data2);
            if (blobType == BlobKey.BlobType.TRANSIENT_BLOB) {
                BlobCachePutTest.verifyDeletedEventually(server, jobId1, key1a);
                BlobCachePutTest.verifyDeletedEventually(server, jobId1, key1b);
                BlobCachePutTest.verifyDeletedEventually(server, jobId2, key2a);
                BlobCachePutTest.verifyDeletedEventually(server, jobId2, key2b);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId1, key1a, data);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId1, key1b, data2);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId2, key2a, data);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId2, key2b, data2);
            } else {
                BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
                BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
                BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
                BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            }
        }
    }

    @Test
    public void testPutStreamTransientSuccessfulGet1() throws IOException, InterruptedException {
        this.testPutStreamTransientSuccessfulGet(null, null);
    }

    @Test
    public void testPutStreamTransientSuccessfulGet2() throws IOException, InterruptedException {
        this.testPutStreamTransientSuccessfulGet(null, new JobID());
    }

    @Test
    public void testPutStreamTransientSuccessfulGet3() throws IOException, InterruptedException {
        this.testPutStreamTransientSuccessfulGet(new JobID(), new JobID());
    }

    @Test
    public void testPutStreamTransientSuccessfulGet4() throws IOException, InterruptedException {
        this.testPutStreamTransientSuccessfulGet(new JobID(), null);
    }

    private void testPutStreamTransientSuccessfulGet(@Nullable JobID jobId1, @Nullable JobID jobId2) throws IOException, InterruptedException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOfRange(data, 10, 54);
            TransientBlobKey key1a = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId1, new ByteArrayInputStream(data), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1a);
            BlobKey key1a2 = BlobServerPutTest.put((BlobService)cache, jobId1, new ByteArrayInputStream(data), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1a2);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1a, key1a2);
            TransientBlobKey key1b = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId1, new ByteArrayInputStream(data2), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1b, data2);
            TransientBlobKey key2a = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId2, new ByteArrayInputStream(data), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1a, (BlobKey)key2a);
            TransientBlobKey key2b = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId2, new ByteArrayInputStream(data2), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1b, (BlobKey)key2b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2b, data2);
            BlobCachePutTest.verifyDeletedEventually(server, jobId1, new BlobKey[]{key1a});
            BlobCachePutTest.verifyDeletedEventually(server, jobId1, new BlobKey[]{key1b});
            BlobCachePutTest.verifyDeletedEventually(server, jobId2, new BlobKey[]{key2a});
            BlobCachePutTest.verifyDeletedEventually(server, jobId2, new BlobKey[]{key2b});
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2b, data2);
        }
    }

    @Test
    public void testPutChunkedStreamTransientSuccessfulGet1() throws IOException, InterruptedException {
        this.testPutChunkedStreamTransientSuccessfulGet(null, null);
    }

    @Test
    public void testPutChunkedStreamTransientSuccessfulGet2() throws IOException, InterruptedException {
        this.testPutChunkedStreamTransientSuccessfulGet(null, new JobID());
    }

    @Test
    public void testPutChunkedStreamTransientSuccessfulGet3() throws IOException, InterruptedException {
        this.testPutChunkedStreamTransientSuccessfulGet(new JobID(), new JobID());
    }

    @Test
    public void testPutChunkedStreamTransientSuccessfulGet4() throws IOException, InterruptedException {
        this.testPutChunkedStreamTransientSuccessfulGet(new JobID(), null);
    }

    private void testPutChunkedStreamTransientSuccessfulGet(@Nullable JobID jobId1, @Nullable JobID jobId2) throws IOException, InterruptedException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOfRange(data, 10, 54);
            TransientBlobKey key1a = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId1, new BlobServerPutTest.ChunkedInputStream(data, 19), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1a);
            BlobKey key1a2 = BlobServerPutTest.put((BlobService)cache, jobId1, new BlobServerPutTest.ChunkedInputStream(data, 19), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1a2);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1a, key1a2);
            TransientBlobKey key1b = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId1, new BlobServerPutTest.ChunkedInputStream(data2, 19), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1b, data2);
            TransientBlobKey key2a = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId2, new BlobServerPutTest.ChunkedInputStream(data, 19), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1a, (BlobKey)key2a);
            TransientBlobKey key2b = (TransientBlobKey)BlobServerPutTest.put((BlobService)cache, jobId2, new BlobServerPutTest.ChunkedInputStream(data2, 19), BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1b, (BlobKey)key2b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, (BlobKey)key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2b, data2);
            BlobCachePutTest.verifyDeletedEventually(server, jobId1, new BlobKey[]{key1a});
            BlobCachePutTest.verifyDeletedEventually(server, jobId1, new BlobKey[]{key1b});
            BlobCachePutTest.verifyDeletedEventually(server, jobId2, new BlobKey[]{key2a});
            BlobCachePutTest.verifyDeletedEventually(server, jobId2, new BlobKey[]{key2b});
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId1, (BlobKey)key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId2, (BlobKey)key2b, data2);
        }
    }

    @Test
    public void testPutBufferFailsNoJob() throws IOException {
        this.testPutBufferFails(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsForJob() throws IOException {
        this.testPutBufferFails(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsForJobHa() throws IOException {
        this.testPutBufferFails(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutBufferFails(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File tempFileDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            tempFileDir = server.createTemporaryFilename().getParentFile().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            this.exception.expect(IOException.class);
            this.exception.expectMessage("PUT operation failed: ");
            BlobServerPutTest.put((BlobService)cache, jobId, data, blobType);
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testPutBufferFailsIncomingNoJob() throws IOException {
        this.testPutBufferFailsIncoming(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsIncomingForJob() throws IOException {
        this.testPutBufferFailsIncoming(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsIncomingForJobHa() throws IOException {
        this.testPutBufferFailsIncoming(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutBufferFailsIncoming(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File tempFileDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            File storageDir;
            server.start();
            tempFileDir = server.createTemporaryFilename().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            this.exception.expect(IOException.class);
            this.exception.expectMessage("PUT operation failed: ");
            try {
                BlobServerPutTest.put((BlobService)cache, jobId, data, blobType);
                storageDir = tempFileDir.getParentFile();
            }
            catch (Throwable throwable) {
                File storageDir2 = tempFileDir.getParentFile();
                Assert.assertArrayEquals((Object[])new String[]{"incoming"}, (Object[])storageDir2.list());
                throw throwable;
            }
            Assert.assertArrayEquals((Object[])new String[]{"incoming"}, (Object[])storageDir.list());
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testPutBufferFailsStoreNoJob() throws IOException {
        this.testPutBufferFailsStore(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsStoreForJob() throws IOException {
        this.testPutBufferFailsStore(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsStoreForJobHa() throws IOException {
        this.testPutBufferFailsStore(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutBufferFailsStore(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File jobStoreDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            jobStoreDir = server.getStorageLocation(jobId, BlobKey.createKey((BlobKey.BlobType)blobType)).getParentFile();
            Assert.assertTrue((boolean)jobStoreDir.setExecutable(true, false));
            Assert.assertTrue((boolean)jobStoreDir.setReadable(true, false));
            Assert.assertTrue((boolean)jobStoreDir.setWritable(false, false));
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            this.exception.expect(IOException.class);
            this.exception.expectMessage("PUT operation failed: ");
            try {
                BlobServerPutTest.put((BlobService)cache, jobId, data, blobType);
            }
            finally {
                File incomingFileDir = new File(jobStoreDir.getParent(), "incoming");
                Assert.assertArrayEquals((Object[])new String[0], (Object[])incomingFileDir.list());
                Assert.assertArrayEquals((Object[])new String[0], (Object[])jobStoreDir.list());
            }
        }
        finally {
            if (jobStoreDir != null) {
                jobStoreDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testConcurrentPutOperationsNoJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentPutOperations(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testConcurrentPutOperationsForJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentPutOperations(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testConcurrentPutOperationsForJobHa() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentPutOperations(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentPutOperations(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException, InterruptedException, ExecutionException {
        List<Path> jars;
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobStore blobStoreServer = (BlobStore)Mockito.mock(BlobStore.class);
        BlobStore blobStoreCache = (BlobStore)Mockito.mock(BlobStore.class);
        int concurrentPutOperations = 2;
        int dataSize = 1024;
        CountDownLatch countDownLatch = new CountDownLatch(concurrentPutOperations);
        byte[] data = new byte[dataSize];
        if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
            File tmpFile = this.temporaryFolder.newFile();
            FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data);
            jars = Collections.singletonList(new Path(tmpFile.getAbsolutePath()));
        } else {
            jars = null;
        }
        ArrayList<CompletableFuture<BlobKey>> allFutures = new ArrayList<CompletableFuture<BlobKey>>(concurrentPutOperations);
        ExecutorService executor = Executors.newFixedThreadPool(concurrentPutOperations);
        try (BlobServer server = new BlobServer(config, blobStoreServer);
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)blobStoreCache);){
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            for (int i = 0; i < concurrentPutOperations; ++i) {
                Supplier<BlobKey> callable = blobType == BlobKey.BlobType.PERMANENT_BLOB ? () -> {
                    try {
                        List keys = BlobClient.uploadJarFiles((InetSocketAddress)serverAddress, (Configuration)config, (JobID)jobId, (List)jars);
                        Assert.assertEquals((long)1L, (long)keys.size());
                        BlobKey uploadedKey = (BlobKey)keys.get(0);
                        BlobServerPutTest.verifyContents((BlobService)server, jobId, uploadedKey, data);
                        return uploadedKey;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not upload blob.", (Throwable)e));
                    }
                } : () -> {
                    try {
                        BlobServerPutTest.BlockingInputStream inputStream = new BlobServerPutTest.BlockingInputStream(countDownLatch, data);
                        BlobKey uploadedKey = BlobServerPutTest.put((BlobService)cache, jobId, inputStream, blobType);
                        BlobServerPutTest.verifyContents((BlobService)server, jobId, uploadedKey, data);
                        return uploadedKey;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not upload blob.", (Throwable)e));
                    }
                };
                CompletableFuture<BlobKey> putFuture = CompletableFuture.supplyAsync(callable, executor);
                allFutures.add(putFuture);
            }
            FutureUtils.ConjunctFuture conjunctFuture = FutureUtils.combineAll(allFutures);
            Collection blobKeys = (Collection)conjunctFuture.get();
            Iterator blobKeyIterator = blobKeys.iterator();
            Assert.assertTrue((boolean)blobKeyIterator.hasNext());
            BlobKey blobKey = (BlobKey)blobKeyIterator.next();
            while (blobKeyIterator.hasNext()) {
                BlobKeyTest.verifyKeyDifferentHashEquals(blobKey, (BlobKey)blobKeyIterator.next());
            }
            BlobServerPutTest.verifyContents((BlobService)server, jobId, blobKey, data);
            if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
                ((BlobStore)Mockito.verify((Object)blobStoreServer, (VerificationMode)Mockito.times((int)1))).put((File)Matchers.any(File.class), (JobID)Matchers.eq((Object)jobId), (BlobKey)Matchers.eq((Object)blobKey));
            } else {
                ((BlobStore)Mockito.verify((Object)blobStoreServer, (VerificationMode)Mockito.times((int)0))).put((File)Matchers.any(File.class), (JobID)Matchers.eq((Object)jobId), (BlobKey)Matchers.eq((Object)blobKey));
            }
            ((BlobStore)Mockito.verify((Object)blobStoreCache, (VerificationMode)Mockito.times((int)0))).put((File)Matchers.any(File.class), (JobID)Matchers.eq((Object)jobId), (BlobKey)Matchers.eq((Object)blobKey));
        }
        finally {
            executor.shutdownNow();
        }
    }

    static void verifyDeletedEventually(BlobServer server, @Nullable JobID jobId, BlobKey ... keys) throws IOException, InterruptedException {
        long deadline = System.currentTimeMillis() + 30000L;
        do {
            Thread.sleep(10L);
        } while (BlobServerCleanupTest.checkFilesExist(jobId, Arrays.asList(keys), server, false) != 0 && System.currentTimeMillis() < deadline);
        for (BlobKey key : keys) {
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId, key);
        }
    }

    public static class PermanentBlobCacheGetStorageLocation
    extends CheckedThread {
        private final PermanentBlobCache cache;
        private final JobID jobId;
        private final BlobKey key;

        PermanentBlobCacheGetStorageLocation(PermanentBlobCache cache, JobID jobId, BlobKey key) {
            this.cache = cache;
            this.jobId = jobId;
            this.key = key;
        }

        public void go() throws Exception {
            this.cache.getStorageLocation(this.jobId, this.key);
        }
    }

    public static class TransientBlobCacheGetStorageLocation
    extends CheckedThread {
        private final TransientBlobCache cache;
        private final JobID jobId;
        private final BlobKey key;

        TransientBlobCacheGetStorageLocation(TransientBlobCache cache, @Nullable JobID jobId, BlobKey key) {
            this.cache = cache;
            this.jobId = jobId;
            this.key = key;
        }

        public void go() throws Exception {
            this.cache.getStorageLocation(this.jobId, this.key);
        }
    }
}

