/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.blob.BlobClientTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobClientSslTest
extends BlobClientTest {
    private static BlobServer BLOB_SSL_SERVER;
    private static BlobServer BLOB_NON_SSL_SERVER;
    private static Configuration sslClientConfig;
    private static Configuration nonSslClientConfig;
    @ClassRule
    public static TemporaryFolder temporarySslFolder;

    @BeforeClass
    public static void startSSLServer() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, temporarySslFolder.newFolder().getAbsolutePath());
        config.setBoolean(SecurityOptions.SSL_ENABLED, true);
        config.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        config.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        BLOB_SSL_SERVER = new BlobServer(config, (BlobStore)new VoidBlobStore());
        BLOB_SSL_SERVER.start();
        sslClientConfig = new Configuration();
        sslClientConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        sslClientConfig.setString(SecurityOptions.SSL_TRUSTSTORE, "src/test/resources/local127.truststore");
        sslClientConfig.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "password");
    }

    @BeforeClass
    public static void startNonSSLServer() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, temporarySslFolder.newFolder().getAbsolutePath());
        config.setBoolean(SecurityOptions.SSL_ENABLED, true);
        config.setBoolean(BlobServerOptions.SSL_ENABLED, false);
        config.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        config.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        BLOB_NON_SSL_SERVER = new BlobServer(config, (BlobStore)new VoidBlobStore());
        BLOB_NON_SSL_SERVER.start();
        nonSslClientConfig = new Configuration();
        nonSslClientConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        nonSslClientConfig.setBoolean(BlobServerOptions.SSL_ENABLED, false);
        nonSslClientConfig.setString(SecurityOptions.SSL_TRUSTSTORE, "src/test/resources/local127.truststore");
        nonSslClientConfig.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "password");
    }

    @AfterClass
    public static void stopServers() throws IOException {
        if (BLOB_SSL_SERVER != null) {
            BLOB_SSL_SERVER.close();
        }
        if (BLOB_NON_SSL_SERVER != null) {
            BLOB_NON_SSL_SERVER.close();
        }
    }

    @Override
    protected Configuration getBlobClientConfig() {
        return sslClientConfig;
    }

    @Override
    protected BlobServer getBlobServer() {
        return BLOB_SSL_SERVER;
    }

    @Override
    @Test
    public void testUploadJarFilesHelper() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_SSL_SERVER, sslClientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLClientFailure() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_SERVER, sslClientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLClientFailure2() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_NON_SSL_SERVER, sslClientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLServerFailure() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_SSL_SERVER, clientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLServerFailure2() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_SSL_SERVER, nonSslClientConfig);
    }

    @Test
    public void testNonSSLConnection() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_SERVER, clientConfig);
    }

    @Test
    public void testNonSSLConnection2() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_SERVER, nonSslClientConfig);
    }

    @Test
    public void testNonSSLConnection3() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_NON_SSL_SERVER, clientConfig);
    }

    @Test
    public void testNonSSLConnection4() throws Exception {
        BlobClientSslTest.uploadJarFile(BLOB_NON_SSL_SERVER, nonSslClientConfig);
    }

    static {
        temporarySslFolder = new TemporaryFolder();
    }
}

